/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.release;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfrog.build.api.release.BuildArtifactsMapping;

public class Promotion
implements Serializable {
    public static final String STAGED = "Staged";
    public static final String RELEASED = "Released";
    public static final String ROLLED_BACK = "Rolled-back";
    private String status;
    private String comment;
    private String ciUser;
    private String timestamp;
    private boolean dryRun;
    private String targetRepo;
    private String sourceRepo;
    private boolean copy;
    private boolean artifacts = true;
    private boolean dependencies = false;
    private Set<String> scopes;
    private Map<String, Collection<String>> properties;
    private boolean failFast = true;
    private List<BuildArtifactsMapping> mappings;

    public Promotion() {
    }

    public Promotion(String status, String comment, String ciUser, String timestamp, boolean dryRun, String targetRepo, String sourceRepo, boolean copy, boolean artifacts, boolean dependencies, Set<String> scopes, Map<String, Collection<String>> properties, boolean failFast, List<BuildArtifactsMapping> mappings) {
        this.status = status;
        this.comment = comment;
        this.ciUser = ciUser;
        this.timestamp = timestamp;
        this.dryRun = dryRun;
        this.targetRepo = targetRepo;
        this.sourceRepo = sourceRepo;
        this.copy = copy;
        this.artifacts = artifacts;
        this.dependencies = dependencies;
        this.scopes = scopes;
        this.properties = properties;
        this.failFast = failFast;
        this.mappings = mappings;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCiUser() {
        return this.ciUser;
    }

    public void setCiUser(String ciUser) {
        this.ciUser = ciUser;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestampDate() {
        return this.getTimestampAsDate(this.getTimestamp());
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public String getTargetRepo() {
        return this.targetRepo;
    }

    public void setTargetRepo(String targetRepo) {
        this.targetRepo = targetRepo;
    }

    public String getSourceRepo() {
        return this.sourceRepo;
    }

    public void setSourceRepo(String sourceRepo) {
        this.sourceRepo = sourceRepo;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public boolean isArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(boolean artifacts) {
        this.artifacts = artifacts;
    }

    public boolean isDependencies() {
        return this.dependencies;
    }

    public void setDependencies(boolean dependencies) {
        this.dependencies = dependencies;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public Map<String, Collection<String>> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Collection<String>> properties) {
        this.properties = properties;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public List<BuildArtifactsMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<BuildArtifactsMapping> mappings) {
        this.mappings = mappings;
    }

    private Date getTimestampAsDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        try {
            return format.parse(timestamp);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

