/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder.dependency;

import com.google.common.collect.Lists;
import java.util.List;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.dependency.Pattern;

public class BuildPatternArtifactsRequestBuilder {
    private String buildName;
    private String buildNumber;
    private boolean transitive;
    private List<Pattern> patterns = Lists.newArrayList();

    public BuildPatternArtifactsRequest build() {
        if (this.buildName == null) {
            throw new IllegalArgumentException("BuildPatternArtifactsRequest must have a build name.");
        }
        if (this.buildNumber == null) {
            throw new IllegalArgumentException("BuildPatternArtifactsRequest must have a build number.");
        }
        BuildPatternArtifactsRequest request = new BuildPatternArtifactsRequest(this.buildName, this.buildNumber);
        request.setTransitive(this.transitive);
        request.setPatterns(this.patterns);
        return request;
    }

    public BuildPatternArtifactsRequestBuilder buildName(String buildName) {
        this.buildName = buildName;
        return this;
    }

    public BuildPatternArtifactsRequestBuilder buildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public BuildPatternArtifactsRequestBuilder pattern(String pattern) {
        this.patterns.add(new Pattern(pattern));
        return this;
    }
}

