/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseImporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.VertexProvider;

@Deprecated
public class DIMACSImporter<V, E>
extends AbstractBaseImporter<V, E>
implements GraphImporter<V, E> {
    private final double defaultWeight;

    public DIMACSImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, double defaultWeight) {
        super(vertexProvider, edgeProvider);
        this.defaultWeight = defaultWeight;
    }

    public DIMACSImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this(vertexProvider, edgeProvider, 1.0);
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        BufferedReader in = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        int size = this.readNodeCount(in);
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            Integer id = i + 1;
            Object vertex = this.vertexProvider.buildVertex(id.toString(), new HashMap<String, Attribute>());
            map.put(id, vertex);
            graph.addVertex(vertex);
        }
        Object[] cols = this.skipComments(in);
        while (cols != null) {
            if (cols[0].equals("e") || cols[0].equals("a")) {
                Integer target;
                Integer source;
                if (cols.length < 3) {
                    throw new ImportException("Failed to parse edge:" + Arrays.toString(cols));
                }
                try {
                    source = Integer.parseInt(cols[1]);
                }
                catch (NumberFormatException e) {
                    throw new ImportException("Failed to parse edge source node:" + e.getMessage(), e);
                }
                try {
                    target = Integer.parseInt((String)cols[2]);
                }
                catch (NumberFormatException e) {
                    throw new ImportException("Failed to parse edge target node:" + e.getMessage(), e);
                }
                String label = "e_" + source + "_" + target;
                Object from = map.get(source);
                if (from == null) {
                    throw new ImportException("Node " + source + " does not exist");
                }
                Object to = map.get(target);
                if (to == null) {
                    throw new ImportException("Node " + target + " does not exist");
                }
                try {
                    Object e = this.edgeProvider.buildEdge(from, to, label, new HashMap<String, Attribute>());
                    graph.addEdge(from, to, e);
                    if (graph.getType().isWeighted()) {
                        double weight = this.defaultWeight;
                        if (cols.length > 3) {
                            weight = Double.parseDouble((String)cols[3]);
                        }
                        graph.setEdgeWeight(e, weight);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ImportException("Failed to import DIMACS graph:" + e.getMessage(), e);
                }
            }
            cols = this.skipComments(in);
        }
    }

    private String[] split(String src) {
        if (src == null) {
            return null;
        }
        return src.split("\\s+");
    }

    private String[] skipComments(BufferedReader input) {
        String[] cols = null;
        try {
            cols = this.split(input.readLine());
            while (cols != null && (cols.length == 0 || cols[0].equals("c") || cols[0].startsWith("%"))) {
                cols = this.split(input.readLine());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cols;
    }

    private int readNodeCount(BufferedReader input) throws ImportException {
        String[] cols = this.skipComments(input);
        if (cols[0].equals("p")) {
            Integer nodes;
            if (cols.length < 3) {
                throw new ImportException("Failed to read number of vertices.");
            }
            try {
                nodes = Integer.parseInt(cols[2]);
            }
            catch (NumberFormatException e) {
                throw new ImportException("Failed to read number of vertices.");
            }
            if (nodes < 0) {
                throw new ImportException("Negative number of vertices.");
            }
            return nodes;
        }
        throw new ImportException("Failed to read number of vertices.");
    }
}

