/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseImporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.VertexProvider;

@Deprecated
public class Graph6Sparse6Importer<V, E>
extends AbstractBaseImporter<V, E>
implements GraphImporter<V, E> {
    private final double defaultWeight;
    private byte[] bytes;
    private int byteIndex;
    private int bitIndex = 0;
    private Format format = Format.GRAPH6;

    public Graph6Sparse6Importer(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, double defaultWeight) {
        super(vertexProvider, edgeProvider);
        this.defaultWeight = defaultWeight;
    }

    public Graph6Sparse6Importer(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this(vertexProvider, edgeProvider, 1.0);
    }

    @Override
    public void importGraph(Graph<V, E> g, Reader input) throws ImportException {
        BufferedReader in = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        String g6 = "";
        try {
            g6 = in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (g6.isEmpty()) {
            throw new ImportException("Failed to read graph");
        }
        this.importGraph(g, g6);
    }

    public void importGraph(Graph<V, E> g, String g6) throws ImportException {
        if ((g6 = g6.replace("\n", "").replace("\r", "")).startsWith(":")) {
            g6 = g6.substring(1, g6.length());
            this.format = Format.SPARSE6;
        } else if (g6.startsWith(">>sparse6<<:")) {
            g6 = g6.substring(12, g6.length());
            this.format = Format.SPARSE6;
        } else if (g6.startsWith(">>graph6<<")) {
            g6 = g6.substring(10, g6.length());
        }
        this.bytes = g6.getBytes();
        this.validateInput();
        this.bitIndex = 0;
        this.byteIndex = 0;
        int n = this.getNumberOfVertices();
        HashMap map = new HashMap();
        for (int i = 0; i < n; ++i) {
            Object vertex = this.vertexProvider.buildVertex("" + i, new HashMap<String, Attribute>());
            map.put(i, vertex);
            g.addVertex(vertex);
        }
        if (this.format == Format.GRAPH6) {
            this.readGraph6(g, map);
        } else {
            this.readSparse6(g, map);
        }
    }

    private void readGraph6(Graph<V, E> g, Map<Integer, V> vertexIndexMap) throws ImportException {
        int requiredBytes = (int)Math.ceil((double)(vertexIndexMap.size() * (vertexIndexMap.size() - 1)) / 12.0) + this.byteIndex;
        if (this.bytes.length < requiredBytes) {
            throw new ImportException("Graph string seems to be corrupt. Not enough data to read graph6 graph");
        }
        for (int i = 0; i < vertexIndexMap.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                int bit = this.getBits(1);
                if (bit != 1) continue;
                V from = vertexIndexMap.get(i);
                V to = vertexIndexMap.get(j);
                String label = "e_" + i + "_" + j;
                Object e = this.edgeProvider.buildEdge(from, to, label, new HashMap<String, Attribute>());
                g.addEdge(from, to, e);
                if (!g.getType().isWeighted()) continue;
                g.setEdgeWeight(e, this.defaultWeight);
            }
        }
    }

    private void readSparse6(Graph<V, E> g, Map<Integer, V> vertexIndexMap) throws ImportException {
        int n = vertexIndexMap.size();
        int k = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        int v = 0;
        for (int dataBits = this.bytes.length * 6 - (this.byteIndex * 6 + this.bitIndex); dataBits >= 1 + k; dataBits -= 1 + k) {
            int b = this.getBits(1);
            int x = this.getBits(k);
            if (b == 1) {
                ++v;
            }
            if (v >= n) break;
            if (x > v) {
                v = x;
                continue;
            }
            V from = vertexIndexMap.get(x);
            V to = vertexIndexMap.get(v);
            String label = "e_" + x + "_" + v;
            Object e = this.edgeProvider.buildEdge(from, to, label, new HashMap<String, Attribute>());
            g.addEdge(from, to, e);
            if (!g.getType().isWeighted()) continue;
            g.setEdgeWeight(e, this.defaultWeight);
        }
    }

    private void validateInput() throws ImportException {
        for (byte b : this.bytes) {
            if (b >= 63 && b <= 126) continue;
            throw new ImportException("Graph string seems to be corrupt. Illegal character detected: " + b);
        }
    }

    private int getNumberOfVertices() throws ImportException {
        int n;
        if (this.bytes.length > 8 && this.bytes[0] == 126 && this.bytes[1] == 126) {
            this.byteIndex += 2;
            n = this.getBits(36);
            if (n < 258048) {
                throw new ImportException("Graph string seems to be corrupt. Invalid number of vertices.");
            }
        } else if (this.bytes.length > 4 && this.bytes[0] == 126) {
            ++this.byteIndex;
            n = this.getBits(18);
            if (n < 63 || n > 258047) {
                throw new ImportException("Graph string seems to be corrupt. Invalid number of vertices.");
            }
        } else {
            n = this.getBits(6);
            if (n < 0 || n > 62) {
                throw new ImportException("Graph string seems to be corrupt. Invalid number of vertices.");
            }
        }
        return n;
    }

    private int getBits(int k) throws ImportException {
        int value = 0;
        if (this.bitIndex > 0 || k < 6) {
            int x = Math.min(k, 6 - this.bitIndex);
            int mask = (1 << x) - 1;
            int y = this.bytes[this.byteIndex] - 63 >> 6 - this.bitIndex - x;
            value = (value << k) + (y &= mask);
            k -= x;
            this.bitIndex += x;
            if (this.bitIndex == 6) {
                ++this.byteIndex;
                this.bitIndex = 0;
            }
        }
        int blocks = k / 6;
        for (int j = 0; j < blocks; ++j) {
            value = (value << 6) + this.bytes[this.byteIndex] - 63;
            ++this.byteIndex;
            k -= 6;
        }
        if (k > 0) {
            int y = this.bytes[this.byteIndex] - 63;
            value = (value << k) + (y >>= 6 - k);
            this.bitIndex = k;
        }
        return value;
    }

    static enum Format {
        GRAPH6,
        SPARSE6;

    }
}

