/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.test.unit.integration.junit3;

import junit.framework.TestCase;
import org.jmock.integration.junit3.VerifyingTestCase;
import testdata.jmock.integration.junit3.FailingExampleTestCase;

public class VerifyingTestCaseTests
extends TestCase {
    private boolean verifierWasRun = false;

    public void testCanBeConstructedWithAName() {
        String name = "NAME";
        VerifyingTestCase testCase = new VerifyingTestCase(name){};
        VerifyingTestCaseTests.assertEquals((String)"name", (String)name, (String)testCase.getName());
    }

    public void testRunsVerifiersAfterTest() throws Throwable {
        ExampleTestCase testCase = new ExampleTestCase();
        testCase.addVerifier(new Runnable(){

            @Override
            public void run() {
                VerifyingTestCaseTests.this.verifierWasRun = true;
            }
        });
        testCase.runBare();
        VerifyingTestCaseTests.assertTrue((boolean)this.verifierWasRun);
    }

    public void testOverridingRunTestDoesNotAffectVerification() throws Throwable {
        ExampleTestCase testCase = new ExampleTestCase(){

            public void runTest() {
            }
        };
        testCase.addVerifier(new Runnable(){

            @Override
            public void run() {
                VerifyingTestCaseTests.this.verifierWasRun = true;
            }
        });
        testCase.runBare();
        VerifyingTestCaseTests.assertTrue((boolean)this.verifierWasRun);
    }

    public void testOverridingSetUpAndTearDownDoesNotAffectVerification() throws Throwable {
        ExampleTestCase testCase = new ExampleTestCase(){

            public void setUp() {
            }

            public void tearDown() {
            }
        };
        testCase.addVerifier(new Runnable(){

            @Override
            public void run() {
                VerifyingTestCaseTests.this.verifierWasRun = true;
            }
        });
        testCase.runBare();
        VerifyingTestCaseTests.assertTrue((boolean)this.verifierWasRun);
    }

    public void testThrowsTestExceptionRatherThanTearDownException() throws Throwable {
        try {
            new FailingExampleTestCase("testThrowsExpectedException").runBare();
            VerifyingTestCaseTests.fail((String)"should have thrown exception");
        }
        catch (Exception actual) {
            VerifyingTestCaseTests.assertSame((Object)FailingExampleTestCase.testException, (Object)actual);
        }
    }

    public void testThrowsTearDownExceptionWhenNoTestException() throws Throwable {
        try {
            new FailingExampleTestCase("testDoesNotThrowException").runBare();
            VerifyingTestCaseTests.fail((String)"should have thrown exception");
        }
        catch (Exception actual) {
            VerifyingTestCaseTests.assertSame((Object)FailingExampleTestCase.tearDownException, (Object)actual);
        }
    }

    public static class ExampleTestCase
    extends VerifyingTestCase {
        public ExampleTestCase() {
            this.setName("testMethod");
        }

        public void testMethod() {
        }
    }
}

