/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import jodd.time.JulianDate;
import jodd.time.TimeUtil;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

public class CalendarConverter
implements TypeConverter<Calendar> {
    @Override
    public Calendar convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof JulianDate) {
            return TimeUtil.toCalendar((LocalDateTime)((JulianDate)value).toLocalDateTime());
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.toCalendar((LocalDateTime)((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return TimeUtil.toCalendar((LocalDate)((LocalDate)value));
        }
        if (value instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(((Number)value).longValue());
            return calendar;
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits((CharSequence)stringValue)) {
            return TimeUtil.toCalendar((LocalDateTime)LocalDateTime.parse(stringValue));
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(milliseconds);
            return calendar;
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

