/*
 * Decompiled with CFR 0.152.
 */
package jodd.system;

import java.util.ArrayList;
import jodd.system.HostInfo;
import jodd.system.SystemUtil;

abstract class JavaInfo
extends HostInfo {
    private final String JAVA_VERSION = SystemUtil.get("java.version");
    private final int JAVA_VERSION_NUMBER = this.detectJavaVersionNumber();
    private final String JAVA_VENDOR = SystemUtil.get("java.vendor");
    private final String JAVA_VENDOR_URL = SystemUtil.get("java.vendor.url");
    private final String JAVA_SPECIFICATION_VERSION = SystemUtil.get("java.specification.version");
    private final String JAVA_SPECIFICATION_NAME = SystemUtil.get("java.specification.name");
    private final String JAVA_SPECIFICATION_VENDOR = SystemUtil.get("java.specification.vendor");
    private final String[] JRE_PACKAGES = this.buildJrePackages(this.JAVA_VERSION_NUMBER);

    JavaInfo() {
    }

    public String getJavaVersion() {
        return this.JAVA_VERSION;
    }

    public int getJavaVersionNumber() {
        return this.JAVA_VERSION_NUMBER;
    }

    public String getJavaVendor() {
        return this.JAVA_VENDOR;
    }

    public String getJavaVendorURL() {
        return this.JAVA_VENDOR_URL;
    }

    public String getJavaSpecificationVersion() {
        return this.JAVA_SPECIFICATION_VERSION;
    }

    public final String getJavaSpecificationName() {
        return this.JAVA_SPECIFICATION_NAME;
    }

    public final String getJavaSpecificationVendor() {
        return this.JAVA_SPECIFICATION_VENDOR;
    }

    public String[] getJrePackages() {
        return this.JRE_PACKAGES;
    }

    private String[] buildJrePackages(int javaVersionNumber) {
        ArrayList<String> packages = new ArrayList<String>();
        switch (javaVersionNumber) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                packages.add("com.sun.org.apache");
            }
            case 4: {
                if (javaVersionNumber == 4) {
                    packages.add("org.apache.crimson");
                    packages.add("org.apache.xalan");
                    packages.add("org.apache.xml");
                    packages.add("org.apache.xpath");
                }
                packages.add("org.ietf.jgss");
                packages.add("org.w3c.dom");
                packages.add("org.xml.sax");
            }
            case 3: {
                packages.add("org.omg");
                packages.add("com.sun.corba");
                packages.add("com.sun.jndi");
                packages.add("com.sun.media");
                packages.add("com.sun.naming");
                packages.add("com.sun.org.omg");
                packages.add("com.sun.rmi");
                packages.add("sunw.io");
                packages.add("sunw.util");
            }
            case 2: {
                packages.add("com.sun.java");
                packages.add("com.sun.image");
            }
        }
        packages.add("sun");
        packages.add("java");
        packages.add("javax");
        return packages.toArray(new String[0]);
    }

    private int detectJavaVersionNumber() {
        String javaVersion = this.JAVA_VERSION;
        int lastDashNdx = javaVersion.lastIndexOf(45);
        if (lastDashNdx != -1) {
            javaVersion = javaVersion.substring(0, lastDashNdx);
        }
        if (javaVersion.startsWith("1.")) {
            int index = javaVersion.indexOf(46, 2);
            return Integer.parseInt(javaVersion.substring(2, index));
        }
        int index = javaVersion.indexOf(46);
        return Integer.parseInt(index == -1 ? javaVersion : javaVersion.substring(0, index));
    }

    public boolean isAtLeastJavaVersion(int version) {
        return this.JAVA_VERSION_NUMBER >= version;
    }

    public boolean isJavaVersion(int version) {
        return this.JAVA_VERSION_NUMBER == version;
    }
}

