/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import jodd.datetime.JDateTime;
import jodd.typeconverter.Converter;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.constraint.TimeAfter;

public class TimeAfterConstraint
implements ValidationConstraint<TimeAfter> {
    protected JDateTime time;

    public TimeAfterConstraint() {
    }

    public TimeAfterConstraint(JDateTime time) {
        this.time = time;
    }

    public JDateTime getTime() {
        return this.time;
    }

    public void setTime(JDateTime time) {
        this.time = time;
    }

    @Override
    public void configure(TimeAfter annotation) {
        this.time = new JDateTime(annotation.value());
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return TimeAfterConstraint.validate(value, this.time);
    }

    public static boolean validate(Object value, JDateTime then) {
        if (value == null) {
            return true;
        }
        JDateTime now = Converter.get().toJDateTime(value);
        return now.isAfter(then);
    }
}

