/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ClassUtils {
    private ClassUtils() {
    }

    public static String nullSafeToString(Class<?> clazz) {
        return clazz == null ? "null" : clazz.getName();
    }

    public static String nullSafeToString(Class<?> ... classes) {
        return ClassUtils.nullSafeToString(Class::getName, classes);
    }

    public static String nullSafeToString(Function<? super Class<?>, ? extends String> mapper, Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return "";
        }
        return Arrays.stream(classes).map(clazz -> clazz == null ? "null" : (String)mapper.apply((Class<?>)clazz)).collect(Collectors.joining(", "));
    }
}

