/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.jxls.reader.ConvertUtilsBeanProvider;
import org.jxls.reader.ConvertUtilsBeanProviderDelegate;
import org.jxls.reader.XLSBlockReader;
import org.jxls.reader.XLSReadStatus;
import org.jxls.reader.XLSRowCursorImpl;
import org.jxls.reader.XLSSheetReader;

public class XLSSheetReaderImpl
implements XLSSheetReader {
    private List<XLSBlockReader> blockReaders = new ArrayList<XLSBlockReader>();
    private String sheetName;
    private int sheetIdx = -1;
    XLSReadStatus readStatus = new XLSReadStatus();
    ConvertUtilsBeanProviderDelegate convertUtilsBeanProvider = new ConvertUtilsBeanProviderDelegate();

    public XLSReadStatus read(Sheet sheet, Map beans) {
        this.readStatus.clear();
        XLSRowCursorImpl cursor = new XLSRowCursorImpl(this.sheetName, sheet);
        for (XLSBlockReader blockReader1 : this.blockReaders) {
            this.readStatus.mergeReadStatus(blockReader1.read(cursor, beans));
            cursor.moveForward();
        }
        return this.readStatus;
    }

    public String getSheetNameBySheetIdx(Sheet sheet, int idx) {
        Sheet sheetAtIdx = sheet.getWorkbook().getSheetAt(idx);
        return sheetAtIdx.getSheetName();
    }

    public void setConvertUtilsBeanProvider(ConvertUtilsBeanProvider provider) {
        this.convertUtilsBeanProvider.setDelegate(provider);
    }

    public List getBlockReaders() {
        return this.blockReaders;
    }

    public void setBlockReaders(List blockReaders) {
        this.blockReaders = blockReaders;
        for (XLSBlockReader blockReader : this.blockReaders) {
            blockReader.setConvertUtilsBeanProvider(this.convertUtilsBeanProvider);
        }
    }

    public void addBlockReader(XLSBlockReader blockReader) {
        blockReader.setConvertUtilsBeanProvider(this.convertUtilsBeanProvider);
        this.blockReaders.add(blockReader);
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getSheetIdx() {
        return this.sheetIdx;
    }

    public void setSheetIdx(int sheetIdx) {
        this.sheetIdx = sheetIdx;
    }
}

