/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.kurento.maven.KurentoDependencyManager;
import org.kurento.maven.ModuleMavenArtifact;
import org.kurento.modulecreator.KurentoModuleCreator;
import org.kurento.modulecreator.KurentoModuleCreatorException;
import org.kurento.modulecreator.PathUtils;
import org.kurento.modulecreator.Result;
import org.kurento.modulecreator.codegen.Error;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(defaultPhase=LifecyclePhase.GENERATE_SOURCES, name="generate-kurento-client", requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class GenerateKurentoJavaClientMojo
extends AbstractMojo {
    private static final String KURENTO_CLIENT_GROUP_ID = "org.kurento";
    private static final String KURENTO_CLIENT_ARTIFACT_ID = "kurento-client";
    private static final String TEMPLATES_FOLDER = "templates";
    @Parameter(defaultValue="${basedir}/src/main/kmd")
    private File sourceDirectory;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/generated-sources/kmd")
    protected File generatedSourceOutputFolder;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/kurento", readonly=true)
    private File kmdOutputFolder;
    protected Log log;
    @Parameter(property="project.build.sourceEncoding")
    protected String encoding;
    @Component
    private BuildContext buildContext;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter
    private List<String> generateCodeForModules = Collections.emptyList();

    protected void addKmdFiles(KurentoModuleCreator krp, Set<File> kmdFiles, KurentoDependencyManager manager) {
        this.log.info((CharSequence)"Preparing code generation tool:");
        for (File kmdFile : kmdFiles) {
            this.getLog().info((CharSequence)("  Adding kmd file to generate code: " + kmdFile));
            krp.addKmdFileToGen(kmdFile.toPath());
        }
        for (String moduleToGenerateCode : this.generateCodeForModules) {
            if (manager.getDependency(moduleToGenerateCode) != null) continue;
            throw new KurentoModuleCreatorException("The module to generate code '" + moduleToGenerateCode + "' doesn't exist in dependencies");
        }
        for (ModuleMavenArtifact dependency : manager.getDependencies()) {
            Path kmdFile = dependency.getKmdFile();
            if (!this.generateCodeForModules.contains(dependency.getName())) {
                this.getLog().info((CharSequence)("  Adding dependency kmd file: " + kmdFile));
                krp.addDependencyKmdFile(kmdFile);
                continue;
            }
            this.getLog().info((CharSequence)("  Adding kmd file to generate code: " + kmdFile));
            krp.addDependencyKmdFileToGen(kmdFile);
        }
    }

    protected void copyKmdFiles(Set<File> kmdFiles, File kurentoOutputFolder) throws MojoFailureException {
        try {
            Path outputPath = kurentoOutputFolder.toPath();
            if (Files.exists(outputPath, new LinkOption[0])) {
                PathUtils.deleteRecursive((Path)outputPath);
            }
            if (!kmdFiles.isEmpty()) {
                Files.createDirectories(outputPath, new FileAttribute[0]);
            }
            for (File kmdFile : kmdFiles) {
                Path kmdPath = kmdFile.toPath();
                String kmdFileName = kmdPath.getFileName().toString();
                Path newFile = outputPath.resolve(kmdFileName);
                Files.copy(kmdPath, newFile, StandardCopyOption.REPLACE_EXISTING);
                this.buildContext.refresh(newFile.toFile());
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Exception copying kmd files", (Throwable)e);
        }
    }

    protected void prepareOutputDirectories(File outputDirectory, File kurentoOutputFolder) {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        if (!kurentoOutputFolder.exists()) {
            kurentoOutputFolder.mkdirs();
        }
    }

    protected Set<File> loadKmdFiles(File sourceDirectory) throws MojoFailureException {
        if (!sourceDirectory.isDirectory()) {
            this.getLog().info((CharSequence)("The folder for Kurento Media Element Definition files (*.kmd.json) is \"" + sourceDirectory.getAbsolutePath() + "\", but it doesn't exist"));
            return Collections.emptySet();
        }
        this.getLog().info((CharSequence)("Searching for kmd files in " + sourceDirectory.getAbsolutePath()));
        try {
            SuffixMapping mapping = new SuffixMapping("kmd.json", Collections.emptySet());
            SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(Collections.singleton("**/*.kmd.json"), Collections.emptySet());
            scan.addSourceMapping((SourceMapping)mapping);
            Set kmdFiles = scan.getIncludedSources(sourceDirectory, null);
            if (kmdFiles.isEmpty()) {
                this.getLog().info((CharSequence)"No kmd files to process in the project");
            } else {
                for (File kmdFile : kmdFiles) {
                    this.getLog().info((CharSequence)("  Found kmd file to generate code: " + kmdFile));
                }
            }
            return kmdFiles;
        }
        catch (InclusionScanException e) {
            throw new MojoFailureException("Exception loading kmd files", (Throwable)e);
        }
    }

    private Path loadTemplatesPath(MavenProject project) throws MojoExecutionException, IOException {
        this.log.info((CharSequence)"Searching for kurento dependencies:");
        if (KURENTO_CLIENT_ARTIFACT_ID.equals(project.getArtifactId()) && KURENTO_CLIENT_GROUP_ID.equals(project.getGroupId())) {
            return this.loadTemplatesPathFromKurentoClient(project.getFile());
        }
        for (Object artObj : project.getArtifacts()) {
            Artifact artifact = (Artifact)artObj;
            this.log.debug((CharSequence)("Exploring dependency: " + artifact));
            if (!KURENTO_CLIENT_ARTIFACT_ID.equals(artifact.getArtifactId()) || !KURENTO_CLIENT_GROUP_ID.equals(artifact.getGroupId())) continue;
            return this.loadTemplatesPathFromKurentoClient(artifact.getFile());
        }
        return null;
    }

    private Path loadTemplatesPathFromKurentoClient(File artifactFile) throws IOException {
        if ("pom.xml".equals(artifactFile.getName())) {
            return artifactFile.toPath().getParent().resolve("src").resolve("main").resolve("resources").resolve(TEMPLATES_FOLDER);
        }
        if (artifactFile.isFile()) {
            return FileSystems.newFileSystem(artifactFile.toPath(), null).getPath("/templates", new String[0]);
        }
        return artifactFile.toPath().resolve(TEMPLATES_FOLDER);
    }

    protected void executeKurentoMavenPlugin(File sourceDirectory, File generatedSourceOutputFolder, File kmdOutputFolder) throws MojoFailureException, MojoExecutionException {
        this.log = this.getLog();
        Set<File> kmdFiles = this.loadKmdFiles(sourceDirectory);
        try {
            KurentoDependencyManager manager = new KurentoDependencyManager(this.log);
            manager.loadDependencies(this.project);
            KurentoModuleCreator krp = new KurentoModuleCreator();
            this.addKmdFiles(krp, kmdFiles, manager);
            krp.loadModulesFromKmdFiles();
            if (krp.hasToGenerateCode()) {
                krp.setDeleteGenDir(true);
                krp.setVerbose(false);
                Path templatesPath = this.loadTemplatesPath(this.project);
                this.log.info((CharSequence)("Templates path: " + templatesPath));
                krp.setTemplatesDir(templatesPath);
                krp.setCodeGenDir(generatedSourceOutputFolder.toPath());
                krp.setListGeneratedFiles(false);
                this.prepareOutputDirectories(generatedSourceOutputFolder, kmdOutputFolder);
                Result result = krp.generateCode();
                if (!result.isSuccess()) {
                    this.getLog().error((CharSequence)"Generation failed");
                    this.getLog().error((CharSequence)"Errors:");
                    for (Error error : result.getErrors()) {
                        this.getLog().error((CharSequence)error.toString());
                    }
                    throw new MojoExecutionException("Kurento Rom Processor found errors: " + result.getErrors());
                }
                this.getLog().info((CharSequence)"Generation success");
                this.project.addCompileSourceRoot(generatedSourceOutputFolder.getPath());
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Exception " + e.getClass().getName() + ":" + e.getMessage() + " in code generation from kmd files. See exception report for details"), (Throwable)e);
            throw new MojoFailureException("Exception in code generation from kmd files. See exception report for details", (Throwable)e);
        }
        this.copyKmdFiles(kmdFiles, kmdOutputFolder);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeKurentoMavenPlugin(this.sourceDirectory, this.generatedSourceOutputFolder, this.kmdOutputFolder);
    }
}

