/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.maven;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.kurento.modulecreator.KurentoModuleCreatorException;

public class ModuleMavenArtifact
implements Closeable {
    private static final int EXTENSION_LENGTH = ".kmd.json".length();
    private static final String META_INF_KURENTO_FOLDER = "META-INF/kurento";
    private Log log;
    private Artifact artifact;
    private JarFile jarFile;
    private File artifactFile;
    private FileSystem jarFS;
    private boolean kurentoArtifact = false;
    private Path kmdFile;
    private String moduleName;

    public ModuleMavenArtifact(Log log, Artifact artifact) throws IOException {
        this.log = log;
        this.artifact = artifact;
        this.artifactFile = artifact.getFile();
        if (this.artifactFile.isFile()) {
            this.jarFile = new JarFile(this.artifactFile);
            JarEntry entry = this.jarFile.getJarEntry(META_INF_KURENTO_FOLDER);
            this.kurentoArtifact = entry != null;
        } else {
            File kurentoFolder = new File(this.artifactFile, META_INF_KURENTO_FOLDER);
            this.kurentoArtifact = kurentoFolder.exists();
        }
        if (this.kurentoArtifact) {
            this.loadKmdFiles();
        }
    }

    private void loadKmdFiles() throws IOException {
        Path kmdFolder = null;
        if (this.artifactFile.isDirectory()) {
            kmdFolder = this.artifactFile.toPath().resolve(META_INF_KURENTO_FOLDER);
        } else {
            this.jarFS = FileSystems.newFileSystem(this.artifactFile.toPath(), null);
            kmdFolder = this.jarFS.getPath("/META-INF/kurento", new String[0]);
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(kmdFolder, "*.kmd.json");){
            this.log.debug((CharSequence)"Exploring dir META-INF/kurento with filter *.kmd.json");
            for (Path kmdFile : directoryStream) {
                if (this.kmdFile == null) {
                    this.kmdFile = kmdFile;
                    continue;
                }
                throw new KurentoModuleCreatorException("Found two or more kmd files in dependency " + this.getArtifactCoordinate());
            }
        }
        if (this.kmdFile == null) {
            throw new KurentoModuleCreatorException("Found /META-INF/kurento folder in dependency " + this.getArtifactCoordinate() + " without .kmd.json file");
        }
        this.moduleName = this.removeExtension(this.kmdFile.getFileName().toString());
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public boolean isKurentoModule() {
        return this.kurentoArtifact;
    }

    public Path getKmdFile() {
        return this.kmdFile;
    }

    public String getArtifactCoordinate() {
        return this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getVersion();
    }

    public String getName() {
        return this.moduleName;
    }

    private String removeExtension(String dependencyId) {
        return dependencyId.substring(0, dependencyId.length() - EXTENSION_LENGTH);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.jarFile != null) {
                this.jarFile.close();
            }
        }
        finally {
            if (this.jarFS != null) {
                this.jarFS.close();
            }
        }
    }
}

