/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.helpers;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.webbitserver.handler.FileEntry;

public class ClassloaderResourceHelper {
    public static Iterable<FileEntry> listFilesRelativeToClass(Class<?> clazz, String subdirectory) throws IOException {
        ZipEntry zipEntry;
        ArrayList<FileEntry> list = new ArrayList<FileEntry>();
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        if (src == null) {
            return list;
        }
        URL classpathEntry = src.getLocation();
        try {
            File file = new File(new File(classpathEntry.toURI()), subdirectory);
            if (file.isDirectory()) {
                return ClassloaderResourceHelper.fileEntriesFor(file.listFiles());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        subdirectory = subdirectory.replace(File.separatorChar, '/');
        if (!subdirectory.endsWith("/")) {
            subdirectory = subdirectory + "/";
        }
        ZipInputStream jarStream = new ZipInputStream(classpathEntry.openStream());
        while ((zipEntry = jarStream.getNextEntry()) != null) {
            String basename;
            int indexOfSlash;
            if (!ClassloaderResourceHelper.isChild(subdirectory, zipEntry.getName()) || (indexOfSlash = (basename = zipEntry.getName().substring(subdirectory.length())).indexOf(47)) >= 0 && indexOfSlash != basename.length() - 1) continue;
            list.add(new FileEntry(basename));
        }
        return list;
    }

    private static boolean isChild(String parent, String name) {
        return name.startsWith(parent);
    }

    public static Iterable<FileEntry> fileEntriesFor(File[] files) {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>(files.length);
        for (File file : files) {
            String filename = file.getName();
            if (file.isDirectory()) {
                filename = filename + "/";
            }
            fileEntries.add(new FileEntry(filename));
        }
        return fileEntries;
    }
}

