/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen;

import com.google.gson.JsonObject;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.kurento.modulecreator.codegen.JsonFusioner;
import org.kurento.modulecreator.codegen.JsonObjectAsMap;
import org.kurento.modulecreator.codegen.PathTemplateLoader;
import org.kurento.modulecreator.codegen.XmlFusioner;
import org.kurento.modulecreator.codegen.function.CamelToUnderscore;
import org.kurento.modulecreator.codegen.function.CppObjectType;
import org.kurento.modulecreator.codegen.function.EscapeString;
import org.kurento.modulecreator.codegen.function.GenerateKurentoClientJsVersion;
import org.kurento.modulecreator.codegen.function.InitializePropertiesValues;
import org.kurento.modulecreator.codegen.function.IsFirstConstructorParam;
import org.kurento.modulecreator.codegen.function.JavaObjectType;
import org.kurento.modulecreator.codegen.function.JsNamespace;
import org.kurento.modulecreator.codegen.function.JsonCppTypeData;
import org.kurento.modulecreator.codegen.function.OrganizeDependencies;
import org.kurento.modulecreator.codegen.function.PackageToFolder;
import org.kurento.modulecreator.codegen.function.SphinxLinks;
import org.kurento.modulecreator.codegen.function.TypeDependencies;
import org.kurento.modulecreator.definition.ModuleDefinition;
import org.kurento.modulecreator.definition.Type;
import org.xml.sax.SAXException;

public class CodeGen {
    private Path templatesFolder;
    private Configuration cfg;
    private final Path outputFolder;
    private final boolean listGeneratedFiles;
    private final boolean verbose;
    private final boolean overwrite;
    private final JsonObject config;

    public CodeGen(Path templatesFolder, Path outputFolder, boolean verbose, boolean listGeneratedFiles, boolean overwrite, JsonObject config) throws IOException {
        this.verbose = verbose;
        this.listGeneratedFiles = listGeneratedFiles;
        this.overwrite = overwrite;
        this.outputFolder = outputFolder;
        this.config = config;
        if (templatesFolder != null) {
            this.setTemplatesDir(templatesFolder);
        }
    }

    public void setTemplatesDir(Path templatesFolder) throws IOException {
        this.templatesFolder = templatesFolder;
        this.cfg = new Configuration();
        this.cfg.setTemplateLoader((TemplateLoader)new PathTemplateLoader(templatesFolder));
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
    }

    public void generateCode(ModuleDefinition module) throws IOException, TemplateException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.templatesFolder, "*.ftl");){
            for (Path path : directoryStream) {
                String name = path.getFileName().toString();
                String templateType = name.split("_")[0];
                this.generateCode(name, module, templateType);
            }
        }
    }

    private void generateCode(String templateName, ModuleDefinition module, String templateType) throws TemplateException, IOException {
        List<Type> types;
        Template temp = this.cfg.getTemplate(templateName);
        if (templateType.equals("remoteClass")) {
            types = module.getRemoteClasses();
        } else if (templateType.equals("complexType")) {
            types = module.getComplexTypes();
        } else if (templateType.equals("event")) {
            types = module.getEvents();
        } else if (templateType.equals("model")) {
            types = null;
        } else {
            throw new RuntimeException("Unknown template type: '" + templateType + "'. It should be 'model', 'remoteClass', 'complexType' or 'event'");
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("getJavaObjectType", new JavaObjectType());
        root.put("getCppObjectType", new CppObjectType());
        root.put("getJsonCppTypeData", new JsonCppTypeData());
        root.put("escapeString", new EscapeString());
        root.put("camelToUnderscore", new CamelToUnderscore());
        root.put("typeDependencies", new TypeDependencies());
        root.put("isFirstConstructorParam", new IsFirstConstructorParam());
        root.put("sphinxLinks", new SphinxLinks(module));
        root.put("getJsNamespace", new JsNamespace());
        root.put("packageToFolder", new PackageToFolder());
        root.put("organizeDependencies", new OrganizeDependencies());
        root.put("initializePropertiesValues", new InitializePropertiesValues());
        root.put("generateKurentoClientJsVersion", new GenerateKurentoClientJsVersion());
        root.put("module", module);
        if (this.config != null) {
            JsonObjectAsMap mapper = new JsonObjectAsMap();
            root.put("config", mapper.createMapFromJsonObject(this.config));
        } else {
            root.put("config", Collections.emptyMap());
        }
        if (types == null) {
            this.generateFile(temp, root);
        } else {
            for (Type type : types) {
                if (templateType.equals("remoteClass")) {
                    root.put("remoteClass", type);
                } else if (templateType.equals("complexType")) {
                    root.put("complexType", type);
                } else if (templateType.equals("event")) {
                    root.put("event", type);
                }
                this.generateFile(temp, root);
            }
        }
    }

    private void generateFile(Template temp, Map<String, Object> root) throws TemplateException, IOException {
        boolean generateFile;
        StringWriter out = new StringWriter();
        temp.process(root, (Writer)out);
        String tempOutput = out.toString();
        if (tempOutput.isEmpty()) {
            System.out.println("No file generation because applying template '" + temp.getName() + "' is empty");
            return;
        }
        StringTokenizer st = new StringTokenizer(tempOutput);
        String fileName = st.nextToken();
        File outputFile = new File(this.outputFolder.toFile(), fileName);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String sourceCode = tempOutput.substring(fileName.length() + 1, tempOutput.length());
        boolean bl = generateFile = !outputFile.exists();
        if (outputFile.exists() && this.overwrite) {
            generateFile = true;
            String oldContent = CodeGen.readFile(outputFile);
            if (oldContent.equals(sourceCode)) {
                generateFile = false;
            }
        }
        if (generateFile) {
            FileWriter writer = new FileWriter(outputFile);
            writer.write(sourceCode);
            ((Writer)writer).close();
        }
        if (this.verbose) {
            System.out.println("File: " + fileName);
            System.out.println();
            System.out.println(sourceCode);
            System.out.println("---------------------------------------");
        }
        if (this.listGeneratedFiles) {
            System.out.print("Processed file:\t" + fileName);
            if (!generateFile) {
                System.out.println("\t(not generated)");
            } else {
                System.out.println();
            }
        }
    }

    public static String readFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8.name());
    }

    public void generateMavenPom(ModuleDefinition module, Path templatePomXml) throws IOException, TemplateException, ParserConfigurationException, SAXException, TransformerException {
        this.generateCode(module);
        if (templatePomXml != null) {
            String[] addTags = new String[]{"/dependencies", "/build/plugins"};
            String[] replaceTags = new String[]{"/properties"};
            Path outputPomXml = this.outputFolder.resolve("pom.xml");
            XmlFusioner fusioner = new XmlFusioner(outputPomXml, templatePomXml, outputPomXml, addTags, replaceTags);
            fusioner.fusionXmls();
        }
    }

    public void generateNpmPackage(ModuleDefinition module, Path templatePackJson, Path templateBowerJson) throws IOException, TemplateException, ParserConfigurationException, SAXException, TransformerException {
        JsonFusioner fusioner;
        Path outputPackJson;
        String[] replaceTags;
        String[] addTags;
        this.generateCode(module);
        if (templatePackJson != null) {
            addTags = new String[]{"/keywords", "/dependencies", "/devDependencies", "/peerDependencies"};
            replaceTags = new String[]{"/repository", "/bugs"};
            outputPackJson = this.outputFolder.resolve("package.json");
            fusioner = new JsonFusioner(outputPackJson, templatePackJson, outputPackJson, addTags, replaceTags);
            fusioner.fusionJsons();
        }
        if (templateBowerJson != null) {
            addTags = new String[]{"/keywords", "/dependencies", "/peerDependencies"};
            replaceTags = new String[]{"/repository", "/bugs"};
            outputPackJson = this.outputFolder.resolve("bower.json");
            fusioner = new JsonFusioner(outputPackJson, templateBowerJson, outputPackJson, addTags, replaceTags);
            fusioner.fusionJsons();
        }
    }
}

