/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen.function;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;

public class EscapeString
implements TemplateMethodModelEx {
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.get(0) == null) {
            return "";
        }
        return this.escapeString(arguments.get(0).toString());
    }

    private String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        if (str == null) {
            return null;
        }
        block11: for (char ch : str.toCharArray()) {
            if (ch > '\u0fff') {
                sb.append("\\u" + Integer.toHexString(ch).toUpperCase());
                continue;
            }
            if (ch > '\u00ff') {
                sb.append("\\u0" + Integer.toHexString(ch).toUpperCase());
                continue;
            }
            if (ch > '\u007f') {
                sb.append("\\u00" + Integer.toHexString(ch).toUpperCase());
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        sb.append('\\');
                        sb.append('b');
                        break;
                    }
                    case '\n': {
                        sb.append('\\');
                        sb.append('n');
                        break;
                    }
                    case '\t': {
                        sb.append('\\');
                        sb.append('t');
                        break;
                    }
                    case '\f': {
                        sb.append('\\');
                        sb.append('f');
                        break;
                    }
                    case '\r': {
                        sb.append('\\');
                        sb.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            sb.append("\\u00" + Integer.toHexString(ch).toUpperCase());
                            break;
                        }
                        sb.append("\\u000" + Integer.toHexString(ch).toUpperCase());
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block11;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block11;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

