/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.kurento.modulecreator.definition.Method;
import org.kurento.modulecreator.definition.ModelElement;
import org.kurento.modulecreator.definition.Property;
import org.kurento.modulecreator.definition.Type;
import org.kurento.modulecreator.definition.TypeRef;

public class RemoteClass
extends Type {
    @SerializedName(value="extends")
    private TypeRef extendsProp;
    private Method constructor;
    private List<Method> methods;
    private List<Property> properties;
    private List<TypeRef> events;
    private boolean abstractClass;

    public RemoteClass(String name, String doc, TypeRef extendsProp) {
        super(name, doc);
        this.extendsProp = extendsProp;
        this.methods = new ArrayList<Method>();
        this.properties = new ArrayList<Property>();
        this.events = new ArrayList<TypeRef>();
    }

    public RemoteClass(String name, String doc, TypeRef extendsProp, Method constructor, List<Method> methods, List<Property> properties, List<TypeRef> events) {
        super(name, doc);
        this.extendsProp = extendsProp;
        this.constructor = constructor;
        this.methods = methods;
        this.properties = properties;
        this.events = events;
    }

    public Method getConstructor() {
        return this.constructor;
    }

    public List<TypeRef> getEvents() {
        return this.events;
    }

    public TypeRef getExtends() {
        return this.extendsProp;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public boolean isAbstract() {
        return this.abstractClass;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void setAbstract(boolean abstractModel) {
        this.abstractClass = abstractModel;
    }

    public void setConstructor(Method constructor) {
        this.constructor = constructor;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setEvents(List<TypeRef> events) {
        this.events = events;
    }

    public void setExtendsProp(TypeRef extendsProp) {
        this.extendsProp = extendsProp;
    }

    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    public boolean isAssignableTo(String remoteClassName) {
        if (this.getName().equals(remoteClassName)) {
            return true;
        }
        if (this.getExtends() != null) {
            return ((RemoteClass)this.getExtends().getType()).isAssignableTo(remoteClassName);
        }
        return false;
    }

    @Override
    public List<ModelElement> getChildren() {
        ArrayList<ModelElement> children = new ArrayList<ModelElement>();
        if (this.extendsProp != null) {
            children.add(this.extendsProp);
        }
        children.addAll(this.properties);
        if (this.constructor != null) {
            children.add(this.constructor);
        }
        children.addAll(this.methods);
        children.addAll(this.events);
        return children;
    }

    public String toString() {
        return "RemoteClass [extends=" + this.extendsProp + ", constructor=" + this.constructor + ", methods=" + this.methods + ", doc=" + this.getDoc() + ", name=" + this.getName() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.abstractClass ? 1231 : 1237);
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 31 * result + (this.events == null ? 0 : this.events.hashCode());
        result = 31 * result + (this.extendsProp == null ? 0 : this.extendsProp.hashCode());
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteClass other = (RemoteClass)obj;
        if (this.abstractClass != other.abstractClass) {
            return false;
        }
        if (this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor)) {
            return false;
        }
        if (this.events == null ? other.events != null : !this.events.equals(other.events)) {
            return false;
        }
        if (this.extendsProp == null ? other.extendsProp != null : !this.extendsProp.equals(other.extendsProp)) {
            return false;
        }
        return !(this.methods == null ? other.methods != null : !this.methods.equals(other.methods));
    }

    public void expandMethodsWithOpsParams() {
        ArrayList<Method> newMethods = new ArrayList<Method>();
        for (Method method : this.methods) {
            newMethods.addAll(method.expandIfOpsParams());
        }
        this.methods.addAll(newMethods);
    }
}

