/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.print;

import java.util.List;
import org.kurento.modulecreator.definition.ComplexType;
import org.kurento.modulecreator.definition.DataItem;
import org.kurento.modulecreator.definition.Event;
import org.kurento.modulecreator.definition.Method;
import org.kurento.modulecreator.definition.ModuleDefinition;
import org.kurento.modulecreator.definition.RemoteClass;
import org.kurento.modulecreator.definition.Return;
import org.kurento.modulecreator.definition.TypeRef;

public class ModuleDefinitionPrinter {
    public static String printModel(ModuleDefinition model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Media objects (remote)\n");
        sb.append("----------------------------------------\n\n");
        for (RemoteClass remoteClass : model.getRemoteClasses()) {
            ModuleDefinitionPrinter.printRemoteClass(sb, remoteClass);
            sb.append("\n");
            sb.append("------------------------------------\n");
        }
        sb.append("\n");
        sb.append("Event types\n");
        sb.append("----------------------------------------\n\n");
        for (Event event : model.getEvents()) {
            sb.append("    ");
            ModuleDefinitionPrinter.printEvent(sb, event);
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("Method parameter and return types\n");
        sb.append("-----------------------------------------\n\n");
        for (ComplexType type : model.getComplexTypes()) {
            sb.append("    ");
            ModuleDefinitionPrinter.printType(sb, type);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void printType(StringBuilder sb, ComplexType type) {
        sb.append(type.getName()).append(" ");
        switch (type.getTypeFormat()) {
            case ENUM: {
                sb.append(type.getValues());
                break;
            }
            case REGISTER: {
                sb.append("{ ");
                ModuleDefinitionPrinter.printDataItems(sb, type.getProperties());
                sb.append(" }");
                break;
            }
            default: {
                sb.append("Unknown");
            }
        }
    }

    public static void printEvent(StringBuilder sb, Event event) {
        sb.append(event.getName()).append(" ");
        if (event.getExtends() != null) {
            sb.append("extends ");
            ModuleDefinitionPrinter.printTypeRef(sb, event.getExtends());
            sb.append(" ");
        }
        sb.append("{ ");
        ModuleDefinitionPrinter.printDataItems(sb, event.getProperties());
        sb.append(" }");
    }

    public static void printRemoteClass(StringBuilder sb, RemoteClass remoteClass) {
        if (remoteClass.isAbstract()) {
            sb.append("abstract ");
        }
        sb.append("class ");
        sb.append(remoteClass.getName());
        if (remoteClass.getExtends() != null) {
            sb.append(" extends ");
            sb.append(remoteClass.getExtends().getName());
        }
        sb.append("\n");
        sb.append("\n");
        if (remoteClass.getConstructor() != null) {
            sb.append("   Declared Constructor: \n");
            sb.append("       ");
            ModuleDefinitionPrinter.printMethod(sb, remoteClass.getConstructor(), true);
            sb.append("\n");
        }
        if (!remoteClass.getMethods().isEmpty()) {
            sb.append("   Declared Methods: \n");
            for (Method method : remoteClass.getMethods()) {
                sb.append("       ");
                ModuleDefinitionPrinter.printMethod(sb, method, false);
            }
            sb.append("\n");
        }
        if (!remoteClass.getEvents().isEmpty()) {
            sb.append("   Declared Events: \n");
            for (TypeRef event : remoteClass.getEvents()) {
                sb.append("       ");
                sb.append(event.getName());
                sb.append("\n");
            }
            sb.append("\n");
        }
    }

    public static void printMethod(StringBuilder sb, Method method, boolean constructor) {
        Return methodReturn = method.getReturn();
        if (methodReturn != null) {
            ModuleDefinitionPrinter.printTypeRef(sb, methodReturn.getType());
            sb.append(" ");
        } else if (!constructor) {
            sb.append("void ");
        }
        if (method.getName() != null) {
            sb.append(method.getName());
        }
        sb.append("(");
        ModuleDefinitionPrinter.printDataItems(sb, method.getParams());
        sb.append(")\n");
    }

    public static void printDataItems(StringBuilder sb, List<? extends DataItem> items) {
        for (DataItem dataItem : items) {
            ModuleDefinitionPrinter.printTypeRef(sb, dataItem.getType());
            sb.append(" ");
            sb.append(dataItem.getName());
            if (dataItem.isOptional()) {
                sb.append("?");
            }
            sb.append(", ");
        }
        if (!items.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    private static void printTypeRef(StringBuilder sb, TypeRef type) {
        sb.append(type.getName());
        if (type.isList()) {
            sb.append("[]");
        }
    }
}

