/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.CloverMerge;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class CloverAggregateMojo
extends AbstractCloverMojo {
    private String span = Interval.DEFAULT_SPAN.toString();

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover aggregate.");
            return;
        }
        if (this.getProject().getModules() != null && this.getProject().getModules().size() > 0) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            if (this.getChildrenCloverDatabases().size() > 0) {
                new File(this.getCloverMergeDatabase()).getParentFile().mkdirs();
                this.mergeCloverDatabases();
            } else {
                this.getLog().warn((CharSequence)"No Clover databases found in children projects - No merge done");
            }
        }
    }

    private List<String> getChildrenCloverDatabases() {
        String relativeCloverDatabasePath = this.resolveCloverDatabase().substring(this.getProject().getBasedir().getPath().length());
        ArrayList<String> dbFiles = new ArrayList<String>();
        List<MavenProject> projects = this.getDescendentModuleProjects(this.getProject());
        for (MavenProject childProject : projects) {
            File cloverDb = new File(childProject.getBasedir(), relativeCloverDatabasePath);
            if (!cloverDb.exists()) continue;
            dbFiles.add(cloverDb.getPath());
        }
        return dbFiles;
    }

    private void mergeCloverDatabases() throws MojoExecutionException {
        List<String> dbFiles = this.getChildrenCloverDatabases();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-s");
        parameters.add(this.span);
        parameters.add("-i");
        parameters.add(this.getCloverMergeDatabase());
        if (this.getLog().isDebugEnabled()) {
            parameters.add("-d");
        }
        parameters.addAll(dbFiles);
        int mergeResult = CloverMerge.mainImpl((String[])((String[])Iterables.toArray(parameters, String.class)));
        if (mergeResult != 0) {
            throw new MojoExecutionException("Clover has failed to merge the children module databases");
        }
    }
}

