/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;

public class DragNDrop
extends AbstractAction {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode[] draggedNodes = guiPackage.getTreeListener().getDraggedNodes();
        JMeterTreeListener treeListener = guiPackage.getTreeListener();
        JMeterTreeNode currentNode = treeListener.getCurrentNode();
        JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
        TestElement te = currentNode.getTestElement();
        if (te instanceof TestPlan || te instanceof WorkBench) {
            parentNode = null;
        }
        if ("drag_n_drop.add".equals(action) && DragNDrop.canAddTo(currentNode, draggedNodes)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], currentNode, currentNode.getChildCount());
            }
        } else if (parentNode != null) {
            if ("drag_n_drop.insert_before".equals(action) && DragNDrop.canAddTo(parentNode, draggedNodes)) {
                this.removeNodesFromParents(draggedNodes);
                for (int i = 0; i < draggedNodes.length; ++i) {
                    int index = parentNode.getIndex(currentNode);
                    GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], parentNode, index);
                }
            } else if ("drag_n_drop.insert_after".equals(action) && DragNDrop.canAddTo(parentNode, draggedNodes)) {
                this.removeNodesFromParents(draggedNodes);
                for (int i = 0; i < draggedNodes.length; ++i) {
                    int index = parentNode.getIndex(currentNode) + 1;
                    GuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], parentNode, index);
                }
            }
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    private static boolean canAddTo(JMeterTreeNode parentNode, JMeterTreeNode[] draggedNodes) {
        boolean ok = MenuFactory.canAddTo(parentNode, draggedNodes);
        if (!ok) {
            Toolkit.getDefaultToolkit().beep();
        }
        return ok;
    }

    private void removeNodesFromParents(JMeterTreeNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            GuiPackage.getInstance().getTreeModel().removeNodeFromParent(nodes[i]);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("drag_n_drop.add");
        commands.add("drag_n_drop.insert_before");
        commands.add("drag_n_drop.insert_after");
    }
}

