/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.StatisticalSampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class StatisticalSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int DEFAULT_NUM_SAMPLE_THRESHOLD = 100;
    private static final long DEFAULT_TIME_THRESHOLD = 60000L;
    private static final int NUM_SAMPLES_THRESHOLD = JMeterUtils.getPropDefault("num_sample_threshold", 100);
    private static final long TIME_THRESHOLD_MS = JMeterUtils.getPropDefault("time_threshold", 60000L);
    private static boolean KEY_ON_THREADNAME = JMeterUtils.getPropDefault("key_on_threadname", false);
    private final int clientConfiguredNumSamplesThreshold = JMeterUtils.getPropDefault("num_sample_threshold", 100);
    private final long clientConfiguredTimeThresholdMs = JMeterUtils.getPropDefault("time_threshold", 60000L);
    private final boolean clientConfiguredKeyOnThreadName = JMeterUtils.getPropDefault("key_on_threadname", false);
    private final RemoteSampleListener listener;
    private final List<SampleEvent> sampleStore = new ArrayList<SampleEvent>();
    private final Map<String, StatisticalSampleResult> sampleTable = new HashMap<String, StatisticalSampleResult>();
    private volatile transient int numSamplesThreshold;
    private volatile transient long timeThresholdMs;
    private volatile transient boolean keyOnThreadName;
    private transient int sampleCount;
    private transient long batchSendTime = -1L;

    @Deprecated
    public StatisticalSampleSender() {
        this(null);
        log.warn("Constructor only intended for use in testing");
    }

    StatisticalSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        if (this.isClientConfigured()) {
            log.info("Using StatisticalSampleSender (client settings) for this run. Thresholds: num=" + this.clientConfiguredNumSamplesThreshold + ", time=" + this.clientConfiguredTimeThresholdMs + ". Key uses ThreadName: " + this.clientConfiguredKeyOnThreadName);
        } else {
            log.info("Using StatisticalSampleSender (server settings) for this run.");
        }
    }

    @Override
    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        try {
            if (this.sampleStore.size() != 0) {
                this.sendBatch();
            }
            this.listener.testEnded(host);
        }
        catch (RemoteException err) {
            log.warn("testEnded(hostname)", (Throwable)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampleOccurred(SampleEvent e) {
        List<SampleEvent> list = this.sampleStore;
        synchronized (list) {
            String key = StatisticalSampleResult.getKey(e, this.keyOnThreadName);
            StatisticalSampleResult statResult = this.sampleTable.get(key);
            if (statResult == null) {
                statResult = new StatisticalSampleResult(e.getResult(), this.keyOnThreadName);
                this.sampleTable.put(key, statResult);
                this.sampleStore.add(new SampleEvent(statResult, e.getThreadGroup()));
            }
            statResult.add(e.getResult());
            ++this.sampleCount;
            boolean sendNow = false;
            if (this.numSamplesThreshold != -1 && this.sampleCount >= this.numSamplesThreshold) {
                sendNow = true;
            }
            long now = 0L;
            if (this.timeThresholdMs != -1L) {
                now = System.currentTimeMillis();
                if (this.batchSendTime == -1L) {
                    this.batchSendTime = now + this.timeThresholdMs;
                }
                if (this.batchSendTime < now) {
                    sendNow = true;
                }
            }
            if (sendNow) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Firing sample");
                    }
                    this.sendBatch();
                    if (this.timeThresholdMs != -1L) {
                        this.batchSendTime = now + this.timeThresholdMs;
                    }
                }
                catch (RemoteException err) {
                    log.warn("sampleOccurred", (Throwable)err);
                }
            }
        }
    }

    private void sendBatch() throws RemoteException {
        if (this.sampleStore.size() > 0) {
            this.listener.processBatch(this.sampleStore);
            this.sampleStore.clear();
            this.sampleTable.clear();
            this.sampleCount = 0;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.isClientConfigured()) {
            this.numSamplesThreshold = this.clientConfiguredNumSamplesThreshold;
            this.timeThresholdMs = this.clientConfiguredTimeThresholdMs;
            this.keyOnThreadName = this.clientConfiguredKeyOnThreadName;
        } else {
            this.numSamplesThreshold = NUM_SAMPLES_THRESHOLD;
            this.timeThresholdMs = TIME_THRESHOLD_MS;
            this.keyOnThreadName = KEY_ON_THREADNAME;
        }
        log.info("Using StatisticalSampleSender for this run." + (this.isClientConfigured() ? " Client config: " : " Server config: ") + " Thresholds: num=" + this.numSamplesThreshold + ", time=" + this.timeThresholdMs + ". Key uses ThreadName: " + this.keyOnThreadName);
        return this;
    }
}

