/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.status;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.status.SvnStatusHandler;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNException;

public class SvnJavaStatusCommand
extends AbstractStatusCommand
implements SvnCommand {
    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN status directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        SvnStatusHandler handler = new SvnStatusHandler(fileSet.getBasedir());
        try {
            SvnJavaUtil.status(javaRepo.getClientManager(), fileSet.getBasedir(), true, true, handler);
            return new StatusScmResult("JavaSVN Library", handler.getFiles());
        }
        catch (SVNException e) {
            return new StatusScmResult("JavaSVN Library", "SVN status failed.", e.getMessage(), false);
        }
    }
}

