/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.server;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.seleniumhq.jetty9.io.EofException;
import org.seleniumhq.jetty9.io.RuntimeIOException;
import org.seleniumhq.jetty9.server.HttpChannelState;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;

public abstract class HttpInput<T>
extends ServletInputStream
implements Runnable {
    private static final Logger LOG = Log.getLogger(HttpInput.class);
    private final byte[] _oneByteBuffer = new byte[1];
    private final Object _lock;
    private HttpChannelState _channelState;
    private ReadListener _listener;
    private Throwable _onError;
    private boolean _notReady;
    private State _contentState = STREAM;
    private State _eofState;
    private long _contentRead;
    protected static final State STREAM = new State(){

        @Override
        public void waitForContent(HttpInput<?> input) throws IOException {
            input.blockForContent();
        }

        public String toString() {
            return "STREAM";
        }
    };
    protected static final State ASYNC = new State(){

        @Override
        public int noContent() throws IOException {
            return 0;
        }

        public String toString() {
            return "ASYNC";
        }
    };
    protected static final State EARLY_EOF = new State(){

        @Override
        public int noContent() throws IOException {
            throw new EofException("Early EOF");
        }

        @Override
        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "EARLY_EOF";
        }
    };
    protected static final State EOF = new State(){

        @Override
        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "EOF";
        }
    };

    protected HttpInput() {
        this(null);
    }

    protected HttpInput(Object lock) {
        this._lock = lock == null ? this : lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(HttpChannelState state) {
        Object object = this.lock();
        synchronized (object) {
            this._channelState = state;
        }
    }

    public final Object lock() {
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            this._listener = null;
            this._onError = null;
            this._notReady = false;
            this._contentState = STREAM;
            this._eofState = null;
            this._contentRead = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        try {
            Object object = this.lock();
            synchronized (object) {
                T item = this.getNextContent();
                return item == null ? 0 : this.remaining(item);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public int read() throws IOException {
        int read = this.read(this._oneByteBuffer, 0, 1);
        return read < 0 ? -1 : this._oneByteBuffer[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock();
        synchronized (object) {
            T item = this.getNextContent();
            if (item == null) {
                this._contentState.waitForContent(this);
                item = this.getNextContent();
                if (item == null) {
                    return this._contentState.noContent();
                }
            }
            int l = this.get(item, b, off, len);
            this._contentRead += (long)l;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getNextContent() throws IOException {
        T content = this.nextContent();
        if (content == null) {
            Object object = this.lock();
            synchronized (object) {
                if (this._eofState != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} eof {}", this, this._eofState);
                    }
                    this._contentState = this._eofState;
                }
            }
        }
        return content;
    }

    protected abstract T nextContent() throws IOException;

    protected abstract int remaining(T var1);

    protected abstract int get(T var1, byte[] var2, int var3, int var4);

    protected abstract void consume(T var1, int var2);

    protected abstract void blockForContent() throws IOException;

    public abstract void content(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onAsyncRead() {
        Object object = this.lock();
        synchronized (object) {
            if (this._listener == null) {
                return false;
            }
        }
        this._channelState.onReadPossible();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentRead() {
        Object object = this.lock();
        synchronized (object) {
            return this._contentRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void earlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.isEOF()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} early EOF", this);
                }
                this._eofState = EARLY_EOF;
                if (this._listener == null) {
                    return;
                }
            }
        }
        this._channelState.onReadPossible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEarlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            return this._contentState == EARLY_EOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageComplete() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.isEOF()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} EOF", this);
                }
                this._eofState = EOF;
                if (this._listener == null) {
                    return;
                }
            }
        }
        this._channelState.onReadPossible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeAll() {
        Object object = this.lock();
        synchronized (object) {
            if (this._onError != null) {
                return false;
            }
            try {
                while (!this.isFinished()) {
                    T item = this.getNextContent();
                    if (item == null) {
                        this._contentState.waitForContent(this);
                        continue;
                    }
                    this.consume(item, this.remaining(item));
                }
                return true;
            }
            catch (IOException e) {
                LOG.debug(e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        Object object = this.lock();
        synchronized (object) {
            return this._contentState == ASYNC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEOF() {
        Object object = this.lock();
        synchronized (object) {
            return this._eofState != null && this._eofState.isEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.lock();
        synchronized (object) {
            return this._contentState.isEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        boolean finished;
        Object object = this.lock();
        synchronized (object) {
            if (this._contentState.isEOF()) {
                return true;
            }
            if (this._listener == null) {
                return true;
            }
            if (this.available() > 0) {
                return true;
            }
            if (this._notReady) {
                return false;
            }
            this._notReady = true;
            finished = this.isFinished();
        }
        if (finished) {
            this._channelState.onReadPossible();
        } else {
            this.unready();
        }
        return false;
    }

    protected void unready() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ReadListener readListener) {
        try {
            boolean content;
            readListener = Objects.requireNonNull(readListener);
            Object object = this.lock();
            synchronized (object) {
                if (this._contentState != STREAM) {
                    throw new IllegalStateException("state=" + this._contentState);
                }
                this._contentState = ASYNC;
                this._listener = readListener;
                this._notReady = true;
                content = this.getNextContent() != null || this.isEOF();
            }
            if (content) {
                this._channelState.onReadPossible();
            } else {
                this.unready();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable x) {
        Object object = this.lock();
        synchronized (object) {
            if (this._onError != null) {
                LOG.warn(x);
            } else {
                this._onError = x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean eof;
        ReadListener listener;
        Throwable error;
        boolean available = false;
        Object object = this.lock();
        synchronized (object) {
            if (!this._notReady || this._listener == null) {
                return;
            }
            error = this._onError;
            listener = this._listener;
            try {
                T item = this.getNextContent();
                available = item != null && this.remaining(item) > 0;
            }
            catch (Exception e) {
                this.failed(e);
            }
            eof = !available && this.isFinished();
            this._notReady = !available && !eof;
        }
        try {
            if (error != null) {
                listener.onError(error);
            } else if (available) {
                listener.onDataAvailable();
            } else if (eof) {
                listener.onAllDataRead();
            } else {
                this.unready();
            }
        }
        catch (Throwable e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            listener.onError(e);
        }
    }

    protected static abstract class State {
        protected State() {
        }

        public void waitForContent(HttpInput<?> in) throws IOException {
        }

        public int noContent() throws IOException {
            return -1;
        }

        public boolean isEOF() {
            return false;
        }
    }
}

