/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.DirectoryPanel;
import org.apache.jmeter.gui.util.ReportMenuFactory;
import org.apache.jmeter.report.gui.AbstractReportGui;
import org.apache.jmeter.report.gui.ReportPageGui;
import org.apache.jmeter.report.writers.gui.HTMLReportWriterGui;
import org.apache.jmeter.testelement.ReportPlan;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class ReportGui
extends AbstractReportGui {
    private static final long serialVersionUID = 240L;
    private JTextField commentPanel;
    private final DirectoryPanel baseDir = new DirectoryPanel(JMeterUtils.getResString((String)"report_base_directory"), Color.white);
    private ArgumentsPanel argsPanel;

    public ReportGui() {
        this.init();
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        JMenu addMenu = new JMenu(JMeterUtils.getResString((String)"Add"));
        addMenu.add(ReportMenuFactory.makeMenuItem(new ReportPageGui().getStaticLabel(), ReportPageGui.class.getName(), "Add"));
        addMenu.add(ReportMenuFactory.makeMenuItem(new HTMLReportWriterGui().getStaticLabel(), HTMLReportWriterGui.class.getName(), "Add"));
        addMenu.add(ReportMenuFactory.makeMenu("menu_config_element", "Add"));
        pop.add(addMenu);
        ReportMenuFactory.addFileMenu(pop);
        ReportMenuFactory.addEditMenu(pop, true);
        return pop;
    }

    public TestElement createTestElement() {
        ReportPlan tp = new ReportPlan();
        this.modifyTestElement((TestElement)tp);
        return tp;
    }

    public void modifyTestElement(TestElement plan) {
        super.configureTestElement(plan);
        if (plan instanceof ReportPlan) {
            ReportPlan rp = (ReportPlan)plan;
            rp.setUserDefinedVariables((Arguments)this.argsPanel.createTestElement());
            rp.setProperty("ReportPlan.comments", this.commentPanel.getText());
            rp.setBasedir(this.baseDir.getFilename());
        }
    }

    @Override
    public String getLabelResource() {
        return "report_plan";
    }

    @Override
    public Collection<String> getMenuCategories() {
        return null;
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el.getProperty("ReportPlan.user_defined_variables") != null) {
            this.argsPanel.configure((TestElement)((Arguments)el.getProperty("ReportPlan.user_defined_variables").getObjectValue()));
        }
        this.commentPanel.setText(el.getPropertyAsString("ReportPlan.comments"));
        this.baseDir.setFilename(el.getPropertyAsString("ReportPlan.basedir"));
    }

    private JPanel createVariablePanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"user_defined_variables"), Color.white);
        return this.argsPanel;
    }

    private Container createCommentPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        panel.setLayout(new BorderLayout(10, 10));
        Container title = this.makeTitlePanel();
        this.commentPanel = new JTextField();
        this.commentPanel.setBackground(Color.white);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"testplan_comments"));
        label.setBackground(Color.white);
        label.setLabelFor(this.commentPanel);
        title.add(label);
        title.add(this.commentPanel);
        panel.add((Component)title, "North");
        panel.add((Component)((Object)this.baseDir), "Center");
        return panel;
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.setBackground(Color.white);
        this.add(this.createCommentPanel(), "North");
        this.add(this.createVariablePanel(), "Center");
    }
}

