/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.jmeter.gui.util.ReportMenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.report.gui.AbstractReportGui;
import org.apache.jmeter.report.gui.BarChartGui;
import org.apache.jmeter.report.gui.LineGraphGui;
import org.apache.jmeter.report.gui.TableGui;
import org.apache.jmeter.testelement.ReportPage;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class ReportPageGui
extends AbstractReportGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField pageTitle = new JLabeledTextField(JMeterUtils.getResString((String)"report_page_title"));
    private JCheckBox makeIndex = new JCheckBox(JMeterUtils.getResString((String)"report_page_index"));
    private JLabeledTextField cssURL = new JLabeledTextField(JMeterUtils.getResString((String)"report_page_style_url"));
    private JLabeledTextField headerURL = new JLabeledTextField(JMeterUtils.getResString((String)"report_page_header"));
    private JLabeledTextField footerURL = new JLabeledTextField(JMeterUtils.getResString((String)"report_page_footer"));
    private JLabeledTextArea introduction = new JLabeledTextArea(JMeterUtils.getResString((String)"report_page_intro"));

    public ReportPageGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.setBackground(Color.white);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(10, 10));
        pane.setBackground(Color.white);
        pane.add((Component)this.getNamePanel(), "North");
        VerticalPanel options = new VerticalPanel(Color.white);
        this.pageTitle.setBackground(Color.white);
        this.makeIndex.setBackground(Color.white);
        this.cssURL.setBackground(Color.white);
        this.headerURL.setBackground(Color.white);
        this.footerURL.setBackground(Color.white);
        this.introduction.setBackground(Color.white);
        options.add((Component)this.pageTitle);
        options.add((Component)this.makeIndex);
        options.add((Component)this.cssURL);
        options.add((Component)this.headerURL);
        options.add((Component)this.footerURL);
        options.add((Component)this.introduction);
        this.add(pane, "North");
        this.add((Component)options, "Center");
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        JMenu addMenu = new JMenu(JMeterUtils.getResString((String)"Add"));
        addMenu.add(ReportMenuFactory.makeMenuItem(new TableGui().getStaticLabel(), TableGui.class.getName(), "Add"));
        addMenu.add(ReportMenuFactory.makeMenuItem(new BarChartGui().getStaticLabel(), BarChartGui.class.getName(), "Add"));
        addMenu.add(ReportMenuFactory.makeMenuItem(new LineGraphGui().getStaticLabel(), LineGraphGui.class.getName(), "Add"));
        pop.add(addMenu);
        ReportMenuFactory.addFileMenu(pop);
        ReportMenuFactory.addEditMenu(pop, true);
        return pop;
    }

    public TestElement createTestElement() {
        ReportPage element = new ReportPage();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        ReportPage page = (ReportPage)element;
        page.setCSS(this.cssURL.getText());
        page.setFooterURL(this.footerURL.getText());
        page.setHeaderURL(this.headerURL.getText());
        page.setIndex(String.valueOf(this.makeIndex.isSelected()));
        page.setIntroduction(this.introduction.getText());
        page.setTitle(this.pageTitle.getText());
    }

    public void configure(TestElement element) {
        super.configure(element);
        ReportPage page = (ReportPage)element;
        this.cssURL.setText(page.getCSS());
        this.footerURL.setText(page.getFooterURL());
        this.headerURL.setText(page.getHeaderURL());
        this.makeIndex.setSelected(page.getIndex());
        this.introduction.setText(page.getIntroduction());
        this.pageTitle.setText(page.getTitle());
    }
}

