/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.atomikos;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.springframework.boot.jta.atomikos.AtomikosLoggingLevel;

public class AtomikosProperties {
    private final Map<String, String> values = new TreeMap<String, String>();

    public void setService(String service) {
        this.set("service", service);
    }

    public void setMaxTimeout(long maxTimeout) {
        this.set("max_timeout", maxTimeout);
    }

    public void setDefaultJtaTimeout(long defaultJtaTimeout) {
        this.set("default_jta_timeout", defaultJtaTimeout);
    }

    public void setMaxActives(int maxActivities) {
        this.set("max_actives", maxActivities);
    }

    public void setEnableLogging(boolean enableLogging) {
        this.set("enable_logging", enableLogging);
    }

    public void setTransactionManagerUniqueName(String uniqueName) {
        this.set("tm_unique_name", uniqueName);
    }

    public void setSerialJtaTransactions(boolean serialJtaTransactions) {
        this.set("serial_jta_transactions", serialJtaTransactions);
    }

    public void setForceShutdownOnVmExit(boolean forceShutdownOnVmExit) {
        this.set("force_shutdown_on_vm_exit", forceShutdownOnVmExit);
    }

    public void setLogBaseName(String logBaseName) {
        this.set("log_base_name", logBaseName);
    }

    public void setLogBaseDir(String logBaseDir) {
        this.set("log_base_dir", logBaseDir);
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.set("checkpoint_interval", checkpointInterval);
    }

    public void setConsoleLogLevel(AtomikosLoggingLevel consoleLogLevel) {
        this.set("console_log_level", (Object)consoleLogLevel);
    }

    public void setOutputDir(String outputDir) {
        this.set("output_dir", outputDir);
    }

    public void setConsoleFileName(String consoleFileName) {
        this.set("console_file_name", consoleFileName);
    }

    public void setConsoleFileCount(int consoleFileCount) {
        this.set("console_file_count", consoleFileCount);
    }

    public void setConsoleFileLimit(int consoleFileLimit) {
        this.set("console_file_limit", consoleFileLimit);
    }

    public void setThreadedTwoPhaseCommit(boolean threadedTwoPhaseCommit) {
        this.set("threaded_2pc", threadedTwoPhaseCommit);
    }

    private void set(String key, Object value) {
        this.set("com.atomikos.icatch.", key, value);
    }

    private void set(String keyPrefix, String key, Object value) {
        if (value != null) {
            this.values.put(keyPrefix + key, value.toString());
        } else {
            this.values.remove(keyPrefix + key);
        }
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        properties.putAll(this.values);
        return properties;
    }
}

