/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.log.Logger;

public class StringFromFile
extends AbstractFunction
implements TestStateListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__StringFromFile";
    static final String ERR_IND = "**ERR**";
    private static final int MIN_PARAM_COUNT = 1;
    private static final int PARAM_NAME = 2;
    private static final int PARAM_START = 3;
    private static final int PARAM_END = 4;
    private static final int MAX_PARAM_COUNT = 4;
    private static final int COUNT_UNUSED = -2;
    private Object[] values;
    private BufferedReader myBread = null;
    private boolean firstTime = false;
    private String fileName;
    private int myStart = -2;
    private int myCurrent = -2;
    private int myEnd = -2;

    public StringFromFile() {
        if (log.isDebugEnabled()) {
            log.debug("++++++++ Construct " + (Object)((Object)this));
        }
    }

    private synchronized void closeFile() {
        if (this.myBread == null) {
            return;
        }
        String tn = Thread.currentThread().getName();
        log.info(tn + " closing file " + this.fileName);
        try {
            this.myBread.close();
        }
        catch (IOException e) {
            log.error("closeFile() error: " + e.toString(), (Throwable)e);
        }
    }

    private synchronized void openFile() {
        String tn = Thread.currentThread().getName();
        this.fileName = ((CompoundVariable)this.values[0]).execute();
        String start = "";
        if (this.values.length >= 3) {
            start = ((CompoundVariable)this.values[2]).execute();
            try {
                this.myStart = Integer.parseInt(start);
            }
            catch (NumberFormatException e) {
                this.myStart = -2;
                log.warn("Exception parsing " + start + " as int, value will not be considered as Start Number sequence");
            }
        }
        if (this.myCurrent == -2) {
            int n = this.myCurrent = this.myStart == -2 ? 1 : this.myStart;
        }
        if (this.values.length >= 4) {
            String tmp = ((CompoundVariable)this.values[3]).execute();
            try {
                this.myEnd = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                this.myEnd = -2;
                log.warn("Exception parsing " + tmp + " as int, value will not be considered as End Number sequence");
            }
        }
        if (this.values.length >= 3) {
            log.info(tn + " Start = " + this.myStart + " Current = " + this.myCurrent + " End = " + this.myEnd);
            if (this.myEnd != -2 && this.myCurrent > this.myEnd) {
                log.info(tn + " No more files to process, " + this.myCurrent + " > " + this.myEnd);
                this.myBread = null;
                return;
            }
            if (this.myStart != -2) {
                log.info(tn + " using format " + this.fileName);
                try {
                    DecimalFormat myFormatter = new DecimalFormat(this.fileName);
                    this.fileName = myFormatter.format(this.myCurrent);
                }
                catch (NumberFormatException e) {
                    log.warn("Bad file name format ", (Throwable)e);
                }
            }
            ++this.myCurrent;
        }
        log.info(tn + " opening file " + this.fileName);
        try {
            this.myBread = new BufferedReader(new FileReader(this.fileName));
        }
        catch (Exception e) {
            log.error("openFile() error: " + e.toString());
            this.myBread = null;
        }
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String myValue = ERR_IND;
        String myName = "StringFromFile_";
        if (this.values.length >= 2) {
            myName = ((CompoundVariable)this.values[1]).execute().trim();
        }
        if (this.firstTime) {
            this.openFile();
            this.firstTime = false;
        }
        if (null != this.myBread) {
            try {
                String line = this.myBread.readLine();
                if (line == null) {
                    String tn = Thread.currentThread().getName();
                    log.info(tn + " EOF on  file " + this.fileName);
                    this.closeFile();
                    this.openFile();
                    if (this.myBread != null) {
                        line = this.myBread.readLine();
                    } else {
                        line = ERR_IND;
                        if (this.myEnd != -2) {
                            log.info(tn + " Detected end of sequence.");
                            throw new JMeterStopThreadException("End of sequence");
                        }
                    }
                }
                myValue = line;
            }
            catch (IOException e) {
                String tn = Thread.currentThread().getName();
                log.error(tn + " error reading file " + e.toString());
            }
        } else if (this.myEnd != -2) {
            String tn = Thread.currentThread().getName();
            log.info(tn + " Detected end of sequence.");
            throw new JMeterStopThreadException("End of sequence");
        }
        if (myName.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(myName, myValue);
        }
        if (log.isDebugEnabled()) {
            String tn = Thread.currentThread().getName();
            log.debug(tn + " name:" + myName + " value:" + myValue);
        }
        return myValue;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        log.debug((Object)((Object)this) + "::StringFromFile.setParameters()");
        this.checkParameterCount(parameters, 1, 4);
        this.values = parameters.toArray();
        StringBuilder sb = new StringBuilder(40);
        sb.append("setParameters(");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(((CompoundVariable)this.values[i]).getRawParameters());
        }
        sb.append(")");
        log.info(sb.toString());
        this.firstTime = true;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public void testStarted() {
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        this.closeFile();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"string_from_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
        desc.add(JMeterUtils.getResString((String)"string_from_file_seq_start"));
        desc.add(JMeterUtils.getResString((String)"string_from_file_seq_final"));
    }
}

