/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.google.common.base.Strings;
import com.nimbusds.jwt.JWT;
import java.util.Collection;
import org.mitre.openid.connect.client.NamedAdminAuthoritiesMapper;
import org.mitre.openid.connect.client.OIDCAuthoritiesMapper;
import org.mitre.openid.connect.client.UserInfoFetcher;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.PendingOIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class OIDCAuthenticationProvider
implements AuthenticationProvider {
    private static Logger logger = LoggerFactory.getLogger(OIDCAuthenticationProvider.class);
    private UserInfoFetcher userInfoFetcher = new UserInfoFetcher();
    private OIDCAuthoritiesMapper authoritiesMapper = new NamedAdminAuthoritiesMapper();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof PendingOIDCAuthenticationToken) {
            PendingOIDCAuthenticationToken token = (PendingOIDCAuthenticationToken)authentication;
            JWT idToken = token.getIdToken();
            UserInfo userInfo = this.userInfoFetcher.loadUserInfo(token);
            if (userInfo != null && !Strings.isNullOrEmpty((String)userInfo.getSub()) && !userInfo.getSub().equals(token.getSub())) {
                throw new UsernameNotFoundException("user_id mismatch between id_token and user_info call: " + token.getSub() + " / " + userInfo.getSub());
            }
            return this.createAuthenticationToken(token, this.authoritiesMapper.mapAuthorities(idToken, userInfo), userInfo);
        }
        return null;
    }

    protected Authentication createAuthenticationToken(PendingOIDCAuthenticationToken token, Collection<? extends GrantedAuthority> authorities, UserInfo userInfo) {
        return new OIDCAuthenticationToken(token.getSub(), token.getIssuer(), userInfo, authorities, token.getIdToken(), token.getAccessTokenValue(), token.getRefreshTokenValue());
    }

    public void setUserInfoFetcher(UserInfoFetcher userInfoFetcher) {
        this.userInfoFetcher = userInfoFetcher;
    }

    public void setAuthoritiesMapper(OIDCAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    public boolean supports(Class<?> authentication) {
        return PendingOIDCAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

