/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.mitre.openid.connect.client.service.RegisteredClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileRegisteredClientService
implements RegisteredClientService {
    private static final Logger logger = LoggerFactory.getLogger(JsonFileRegisteredClientService.class);
    private Gson gson = new GsonBuilder().registerTypeAdapter(RegisteredClient.class, (Object)new JsonSerializer<RegisteredClient>(){

        public JsonElement serialize(RegisteredClient src, Type typeOfSrc, JsonSerializationContext context) {
            return ClientDetailsEntityJsonProcessor.serialize((RegisteredClient)src);
        }
    }).registerTypeAdapter(RegisteredClient.class, (Object)new JsonDeserializer<RegisteredClient>(){

        public RegisteredClient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ClientDetailsEntityJsonProcessor.parseRegistered((JsonElement)json);
        }
    }).setPrettyPrinting().create();
    private File file;
    private Map<String, RegisteredClient> clients = new HashMap<String, RegisteredClient>();

    public JsonFileRegisteredClientService(String filename) {
        this.file = new File(filename);
        this.load();
    }

    @Override
    public RegisteredClient getByIssuer(String issuer) {
        return this.clients.get(issuer);
    }

    @Override
    public void save(String issuer, RegisteredClient client) {
        this.clients.put(issuer, client);
        this.write();
    }

    private void write() {
        try {
            if (!this.file.exists()) {
                logger.info("Creating saved clients list in " + this.file);
                this.file.createNewFile();
            }
            FileWriter out = new FileWriter(this.file);
            this.gson.toJson(this.clients, new TypeToken<Map<String, RegisteredClient>>(){}.getType(), (Appendable)out);
            out.close();
        }
        catch (IOException e) {
            logger.error("Could not write to output file", (Throwable)e);
        }
    }

    private void load() {
        try {
            if (!this.file.exists()) {
                logger.info("No sved clients file found in " + this.file);
                return;
            }
            FileReader in = new FileReader(this.file);
            this.clients = (Map)this.gson.fromJson((Reader)in, new TypeToken<Map<String, RegisteredClient>>(){}.getType());
            in.close();
        }
        catch (IOException e) {
            logger.error("Could not read from input file", (Throwable)e);
        }
    }
}

