/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.discovery.util.WebfingerURLNormalizer;
import org.mitre.openid.connect.client.model.IssuerServiceResponse;
import org.mitre.openid.connect.client.service.IssuerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;

public class WebfingerIssuerService
implements IssuerService {
    private static final Logger logger = LoggerFactory.getLogger(WebfingerIssuerService.class);
    private LoadingCache<String, LoadingResult> issuers;
    private Set<String> whitelist = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();
    private String parameterName = "identifier";
    private String loginPageUrl;
    private boolean forceHttps = true;

    public WebfingerIssuerService() {
        this((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
    }

    public WebfingerIssuerService(HttpClient httpClient) {
        this.issuers = CacheBuilder.newBuilder().build((CacheLoader)new WebfingerIssuerFetcher(httpClient));
    }

    @Override
    public IssuerServiceResponse getIssuer(HttpServletRequest request) {
        String identifier = request.getParameter(this.parameterName);
        if (!Strings.isNullOrEmpty((String)identifier)) {
            try {
                LoadingResult lr = (LoadingResult)this.issuers.get((Object)identifier);
                if (!this.whitelist.isEmpty() && !this.whitelist.contains(lr.issuer)) {
                    throw new AuthenticationServiceException("Whitelist was nonempty, issuer was not in whitelist: " + lr.issuer);
                }
                if (this.blacklist.contains(lr.issuer)) {
                    throw new AuthenticationServiceException("Issuer was in blacklist: " + lr.issuer);
                }
                return new IssuerServiceResponse(lr.issuer, lr.loginHint, request.getParameter("target_link_uri"));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                logger.warn("Issue fetching issuer for user input: " + identifier + ": " + e.getMessage());
                return null;
            }
        }
        logger.warn("No user input given, directing to login page: " + this.loginPageUrl);
        return new IssuerServiceResponse(this.loginPageUrl);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(Set<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    public boolean isForceHttps() {
        return this.forceHttps;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    private class WebfingerIssuerFetcher
    extends CacheLoader<String, LoadingResult> {
        private HttpComponentsClientHttpRequestFactory httpFactory;
        private JsonParser parser = new JsonParser();

        WebfingerIssuerFetcher(HttpClient httpClient) {
            this.httpFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
        }

        public LoadingResult load(String identifier) throws Exception {
            UriComponents key = WebfingerURLNormalizer.normalizeResource((String)identifier);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
            String scheme = key.getScheme();
            if (!Strings.isNullOrEmpty((String)scheme) && scheme.equals("http")) {
                if (WebfingerIssuerService.this.forceHttps) {
                    throw new IllegalArgumentException("Scheme must not be 'http'");
                }
                logger.warn("Webfinger endpoint MUST use the https URI scheme, overriding by configuration");
                scheme = "http://";
            } else {
                scheme = "https://";
            }
            URIBuilder builder = new URIBuilder(scheme + key.getHost() + (key.getPort() >= 0 ? ":" + key.getPort() : "") + Strings.nullToEmpty((String)key.getPath()) + "/.well-known/webfinger" + (Strings.isNullOrEmpty((String)key.getQuery()) ? "" : "?" + key.getQuery()));
            builder.addParameter("resource", identifier);
            builder.addParameter("rel", "http://openid.net/specs/connect/1.0/issuer");
            try {
                logger.info("Loading: " + builder.toString());
                String webfingerResponse = (String)restTemplate.getForObject(builder.build(), String.class);
                JsonElement json = this.parser.parse(webfingerResponse);
                if (json != null && json.isJsonObject()) {
                    JsonArray links = json.getAsJsonObject().get("links").getAsJsonArray();
                    for (JsonElement link : links) {
                        JsonObject linkObj;
                        if (!link.isJsonObject() || !(linkObj = link.getAsJsonObject()).has("href") || !linkObj.has("rel") || !linkObj.get("rel").getAsString().equals("http://openid.net/specs/connect/1.0/issuer")) continue;
                        String href = linkObj.get("href").getAsString();
                        if (identifier.equals(href) || identifier.startsWith("http")) {
                            return new LoadingResult(null, href);
                        }
                        return new LoadingResult(identifier, href);
                    }
                }
            }
            catch (JsonParseException | RestClientException e) {
                logger.warn("Failure in fetching webfinger input", (Object)e.getMessage());
            }
            if (key.getScheme().equals("http") || key.getScheme().equals("https")) {
                logger.warn("Returning normalized input string as issuer, hoping for the best: " + identifier);
                return new LoadingResult(null, identifier);
            }
            logger.warn("Couldn't find issuer: " + identifier);
            throw new IllegalArgumentException();
        }
    }

    private class LoadingResult {
        public String loginHint;
        public String issuer;

        public LoadingResult(String loginHint, String issuer) {
            this.loginHint = loginHint;
            this.issuer = issuer;
        }
    }
}

