/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.codec;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.FullHttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;

public class MockServerResponseDecoder
extends MessageToMessageDecoder<FullHttpResponse> {
    protected void decode(ChannelHandlerContext ctx, FullHttpResponse fullHttpResponse, List<Object> out) {
        HttpResponse httpResponse = new HttpResponse();
        if (fullHttpResponse != null) {
            this.setStatusCode(httpResponse, fullHttpResponse);
            this.setHeaders(httpResponse, fullHttpResponse);
            this.setCookies(httpResponse);
            this.setBody(httpResponse, fullHttpResponse);
        }
        out.add(httpResponse);
    }

    private void setStatusCode(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        httpResponse.withStatusCode(fullHttpResponse.getStatus().code());
    }

    private void setHeaders(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        HashMap<String, Header> mappedHeaders = new HashMap<String, Header>();
        for (String headerName : fullHttpResponse.headers().names()) {
            mappedHeaders.put(headerName, new Header(headerName, fullHttpResponse.headers().getAll(headerName)));
        }
        ArrayList<Header> headers = new ArrayList<Header>(mappedHeaders.values());
        httpResponse.withHeaders(headers);
    }

    private void setCookies(HttpResponse httpResponse) {
        HashMap<String, org.mockserver.model.Cookie> mappedCookies = new HashMap<String, org.mockserver.model.Cookie>();
        for (Header header : httpResponse.getHeaders()) {
            if (!header.getName().equals("Cookie") && !header.getName().equals("Set-Cookie")) continue;
            for (String cookieHeader : header.getValues()) {
                for (Cookie httpCookie : CookieDecoder.decode((String)cookieHeader)) {
                    String name = httpCookie.getName().trim();
                    String value = httpCookie.getValue().trim();
                    mappedCookies.put(name, new org.mockserver.model.Cookie(name, value));
                }
            }
        }
        httpResponse.withCookies(new ArrayList<org.mockserver.model.Cookie>(mappedCookies.values()));
    }

    private void setBody(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            ByteBuf byteBuf = fullHttpResponse.content().readBytes(fullHttpResponse.content().readableBytes());
            if (ContentTypeMapper.isBinary(fullHttpResponse.headers().get("Content-Type"))) {
                httpResponse.withBody(byteBuf.array());
            } else {
                httpResponse.withBody(byteBuf.toString(Charsets.UTF_8));
            }
        }
    }
}

