/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.model.ExpectationDTO;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestSerializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public String serialize(HttpRequest httpRequest) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new HttpRequestDTO(httpRequest));
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception while serializing httpRequest to JSON with value %s", httpRequest), (Throwable)e);
            throw new RuntimeException(String.format("Exception while serializing httpRequest to JSON with value %s", httpRequest), e);
        }
    }

    public HttpRequest deserialize(String jsonHttpRequest) {
        HttpRequest httpRequest = null;
        if (jsonHttpRequest != null && !jsonHttpRequest.isEmpty()) {
            try {
                if (!jsonHttpRequest.contains("\"httpRequest\"")) {
                    HttpRequestDTO httpRequestDTO = (HttpRequestDTO)this.objectMapper.readValue(jsonHttpRequest, HttpRequestDTO.class);
                    if (httpRequestDTO != null) {
                        httpRequest = httpRequestDTO.buildObject();
                    }
                } else {
                    ExpectationDTO expectationDTO = (ExpectationDTO)this.objectMapper.readValue(jsonHttpRequest, ExpectationDTO.class);
                    if (expectationDTO != null) {
                        httpRequest = expectationDTO.buildObject().getHttpRequest();
                    }
                }
            }
            catch (Exception e) {
                this.logger.info("Exception while parsing response [" + jsonHttpRequest + "] for http response httpRequest", (Throwable)e);
                throw new RuntimeException("Exception while parsing response [" + jsonHttpRequest + "] for http response httpRequest", e);
            }
        }
        return httpRequest;
    }

    public String serialize(List<HttpRequest> httpRequests) {
        return this.serialize(httpRequests.toArray(new HttpRequest[httpRequests.size()]));
    }

    public String serialize(HttpRequest[] httpRequest) {
        try {
            if (httpRequest != null && httpRequest.length > 0) {
                HttpRequestDTO[] httpRequestDTOs = new HttpRequestDTO[httpRequest.length];
                for (int i = 0; i < httpRequest.length; ++i) {
                    httpRequestDTOs[i] = new HttpRequestDTO(httpRequest[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)httpRequestDTOs);
            }
            return "";
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing http request to JSON with value " + Arrays.asList(httpRequest), (Throwable)e);
            throw new RuntimeException("Exception while serializing http request to JSON with value " + Arrays.asList(httpRequest), e);
        }
    }
}

