/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.CookieDTO;
import org.mockserver.client.serialization.model.DelayDTO;
import org.mockserver.client.serialization.model.HeaderDTO;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HttpResponseDTO
extends ObjectWithReflectiveEqualsHashCodeToString {
    private Integer statusCode;
    private BodyDTO body;
    private List<CookieDTO> cookies = new ArrayList<CookieDTO>();
    private List<HeaderDTO> headers = new ArrayList<HeaderDTO>();
    private DelayDTO delay;

    public HttpResponseDTO(HttpResponse httpResponse) {
        if (httpResponse != null) {
            this.statusCode = httpResponse.getStatusCode();
            this.body = BodyDTO.createDTO(httpResponse.getBody());
            this.headers = Lists.transform(httpResponse.getHeaders(), (Function)new Function<Header, HeaderDTO>(){

                public HeaderDTO apply(Header header) {
                    return new HeaderDTO(header);
                }
            });
            this.cookies = Lists.transform(httpResponse.getCookies(), (Function)new Function<Cookie, CookieDTO>(){

                public CookieDTO apply(Cookie cookie) {
                    return new CookieDTO(cookie);
                }
            });
            this.delay = httpResponse.getDelay() != null ? new DelayDTO(httpResponse.getDelay()) : null;
        }
    }

    public HttpResponseDTO() {
    }

    public HttpResponse buildObject() {
        return new HttpResponse().withStatusCode(this.statusCode).withBody(this.body != null ? this.body.buildObject() : null).withHeaders(Lists.transform(this.headers, (Function)new Function<HeaderDTO, Header>(){

            public Header apply(HeaderDTO header) {
                return header.buildObject();
            }
        })).withCookies(Lists.transform(this.cookies, (Function)new Function<CookieDTO, Cookie>(){

            public Cookie apply(CookieDTO cookie) {
                return cookie.buildObject();
            }
        })).withDelay(this.delay != null ? this.delay.buildObject() : null);
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponseDTO setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public HttpResponseDTO setBody(BodyDTO body) {
        this.body = body;
        return this;
    }

    public List<CookieDTO> getCookies() {
        return this.cookies;
    }

    public HttpResponseDTO setCookies(List<CookieDTO> cookies) {
        this.cookies = cookies;
        return this;
    }

    public List<HeaderDTO> getHeaders() {
        return this.headers;
    }

    public HttpResponseDTO setHeaders(List<HeaderDTO> headers) {
        this.headers = headers;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpResponseDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }
}

