/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HashMapMatcher
extends ObjectWithReflectiveEqualsHashCodeToString
implements Matcher<List<KeyAndValue>> {
    private final CaseInsensitiveRegexHashMap multiMap;

    public HashMapMatcher(CaseInsensitiveRegexHashMap multiMap) {
        this.multiMap = multiMap;
    }

    @Override
    public boolean matches(List<KeyAndValue> values) {
        boolean result = false;
        if (KeyAndValue.toHashMap(values).containsAll(this.multiMap)) {
            result = true;
        } else {
            this.logger.trace("Map [{}] is not a subset of [{}]", (Object)this.multiMap, (Object)KeyAndValue.toHashMap(values));
        }
        return result;
    }
}

