/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.XPathStringMatcher;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.StringBody;

public class HttpRequestMatcher
extends ObjectWithReflectiveEqualsHashCodeToString
implements Matcher<HttpRequest> {
    private HttpRequest httpRequest;
    private RegexStringMatcher methodMatcher = null;
    private RegexStringMatcher pathMatcher = null;
    private MultiValueMapMatcher queryStringParameterMatcher = null;
    private BodyMatcher bodyMatcher = null;
    private MultiValueMapMatcher headerMatcher = null;
    private HashMapMatcher cookieMatcher = null;

    public HttpRequestMatcher(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        if (httpRequest != null) {
            this.withMethod(httpRequest.getMethod());
            this.withPath(httpRequest.getPath());
            this.withQueryStringParameters(httpRequest.getQueryStringParameters());
            this.withBody(httpRequest.getBody());
            this.withHeaders(httpRequest.getHeaders());
            this.withCookies(httpRequest.getCookies());
        }
    }

    private HttpRequestMatcher withMethod(String method) {
        this.methodMatcher = new RegexStringMatcher(method);
        return this;
    }

    private HttpRequestMatcher withPath(String path) {
        this.pathMatcher = new RegexStringMatcher(path);
        return this;
    }

    private HttpRequestMatcher withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(parameters));
        return this;
    }

    private HttpRequestMatcher withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    this.bodyMatcher = new ExactStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case REGEX: {
                    this.bodyMatcher = new RegexStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case PARAMETERS: {
                    this.bodyMatcher = new ParameterStringMatcher((List<Parameter>)((ParameterBody)body).getValue());
                    break;
                }
                case XPATH: {
                    this.bodyMatcher = new XPathStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case JSON: {
                    this.bodyMatcher = new JsonStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case BINARY: {
                    this.bodyMatcher = new BinaryMatcher(((BinaryBody)body).getValue());
                }
            }
        }
        return this;
    }

    private HttpRequestMatcher withHeaders(Header ... headers) {
        this.headerMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpRequestMatcher withHeaders(List<Header> headers) {
        this.headerMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpRequestMatcher withCookies(Cookie ... cookies) {
        this.cookieMatcher = new HashMapMatcher(KeyAndValue.toHashMap(cookies));
        return this;
    }

    private HttpRequestMatcher withCookies(List<Cookie> cookies) {
        this.cookieMatcher = new HashMapMatcher(KeyAndValue.toHashMap(cookies));
        return this;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        if (httpRequest == this.httpRequest) {
            return true;
        }
        if (httpRequest != null) {
            boolean result;
            boolean methodMatches = this.matches(this.methodMatcher, httpRequest.getMethod());
            boolean pathMatches = this.matches(this.pathMatcher, httpRequest.getPath());
            boolean queryStringParametersMatches = this.matches(this.queryStringParameterMatcher, httpRequest.getQueryStringParameters() != null ? new ArrayList<Parameter>(httpRequest.getQueryStringParameters()) : null);
            boolean bodyMatches = this.bodyMatcher instanceof BinaryMatcher ? this.matches(this.bodyMatcher, httpRequest.getBodyAsRawBytes()) : this.matches(this.bodyMatcher, httpRequest.getBody() != null ? new String(httpRequest.getBody().getRawBytes(), Charsets.UTF_8) : "");
            boolean headersMatch = this.matches(this.headerMatcher, httpRequest.getHeaders() != null ? new ArrayList<Header>(httpRequest.getHeaders()) : null);
            boolean cookiesMatch = this.matches(this.cookieMatcher, httpRequest.getCookies() != null ? new ArrayList<Cookie>(httpRequest.getCookies()) : null);
            boolean bl = result = methodMatches && pathMatches && queryStringParametersMatches && bodyMatches && headersMatch && cookiesMatch;
            if (!result && this.logger.isDebugEnabled()) {
                this.logger.debug("\n\nMatcher:" + System.getProperty("line.separator") + System.getProperty("line.separator") + "[" + this + "]" + System.getProperty("line.separator") + System.getProperty("line.separator") + "did not match request:" + System.getProperty("line.separator") + System.getProperty("line.separator") + "[" + httpRequest + "]" + System.getProperty("line.separator") + System.getProperty("line.separator") + "because:" + System.getProperty("line.separator") + System.getProperty("line.separator") + "methodMatches = " + methodMatches + "" + System.getProperty("line.separator") + "pathMatches = " + pathMatches + "" + System.getProperty("line.separator") + "queryStringParametersMatch = " + queryStringParametersMatches + "" + System.getProperty("line.separator") + "bodyMatches = " + bodyMatches + "" + System.getProperty("line.separator") + "headersMatch = " + headersMatch + "" + System.getProperty("line.separator") + "cookiesMatch = " + cookiesMatch);
            }
            return result;
        }
        return false;
    }

    private <T> boolean matches(Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(t)) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

