/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Action;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerMatcher
extends ObjectWithReflectiveEqualsHashCodeToString {
    protected final List<Expectation> expectations = new ArrayList<Expectation>();
    private Logger requestLogger = LoggerFactory.getLogger((String)"REQUEST");

    public synchronized Expectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public synchronized Expectation when(final HttpRequest httpRequest, Times times) {
        Expectation expectation;
        if (times.isUnlimited()) {
            Collection existingExpectationsWithMatchingRequest = Collections2.filter(this.expectations, (Predicate)new Predicate<Expectation>(){

                public boolean apply(Expectation expectation) {
                    return expectation.contains(httpRequest);
                }
            });
            if (!existingExpectationsWithMatchingRequest.isEmpty()) {
                for (Expectation existingExpectation : existingExpectationsWithMatchingRequest) {
                    existingExpectation.setNotUnlimitedResponses();
                }
                expectation = new Expectation(httpRequest, Times.once());
            } else {
                expectation = new Expectation(httpRequest, Times.unlimited());
            }
        } else {
            expectation = new Expectation(httpRequest, times);
        }
        this.expectations.add(expectation);
        return expectation;
    }

    public synchronized Action handle(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>(this.expectations);
        for (Expectation expectation : expectations) {
            if (!expectation.matches(httpRequest)) continue;
            expectation.decrementRemainingMatches();
            if (!expectation.getTimes().greaterThenZero() && this.expectations.contains(expectation)) {
                this.expectations.remove(expectation);
            }
            return expectation.getAction(true);
        }
        return null;
    }

    public synchronized void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = new MatcherBuilder().transformsToMatcher(httpRequest);
            for (Expectation expectation : new ArrayList<Expectation>(this.expectations)) {
                if (!httpRequestMatcher.matches(expectation.getHttpRequest()) || !this.expectations.contains(expectation)) continue;
                this.expectations.remove(expectation);
            }
        } else {
            this.reset();
        }
    }

    public synchronized void reset() {
        this.expectations.clear();
    }

    public synchronized void dumpToLog(HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationSerializer expectationSerializer = new ExpectationSerializer();
            for (Expectation expectation : new ArrayList<Expectation>(this.expectations)) {
                if (!expectation.matches(httpRequest)) continue;
                this.requestLogger.warn(this.cleanBase64Response(expectationSerializer.serialize(expectation)));
            }
        } else {
            ExpectationSerializer expectationSerializer = new ExpectationSerializer();
            for (Expectation expectation : new ArrayList<Expectation>(this.expectations)) {
                this.requestLogger.warn(this.cleanBase64Response(expectationSerializer.serialize(expectation)));
            }
        }
    }

    @VisibleForTesting
    String cleanBase64Response(String serializedExpectation) {
        Pattern base64ResponseBodyPattern = Pattern.compile("[\\s\\S]*\\\"httpResponse\\\"\\s*\\:\\s*\\{[\\s\\S]*\\\"body\\\"\\s*\\:\\s*\\\"(([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==))\\\"[\\s\\S]*");
        Matcher matcher = base64ResponseBodyPattern.matcher(serializedExpectation);
        if (matcher.find()) {
            return serializedExpectation.replace(matcher.group(1), new String(Base64Converter.base64StringToBytes(matcher.group(1))));
        }
        return serializedExpectation;
    }
}

