/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.unification;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class PortUnificationHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    public static final AttributeKey<Boolean> SSL_ENABLED = AttributeKey.valueOf((String)"SERVER_SSL_ENABLED");
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PortUnificationHandler() {
        super(false);
    }

    public static boolean isSslEnabled(ChannelHandlerContext ctx) {
        if (ctx.channel().attr(SSL_ENABLED).get() != null) {
            return (Boolean)ctx.channel().attr(SSL_ENABLED).get();
        }
        return false;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (msg.readableBytes() < 5) {
            return;
        }
        if (this.isSsl(msg)) {
            this.enableSsl(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.switchToHttp(ctx, msg);
        } else {
            msg.clear();
            ctx.close();
        }
    }

    private boolean isSsl(ByteBuf buf) {
        return SslHandler.isEncrypted((ByteBuf)buf);
    }

    private boolean isHttp(ByteBuf msg) {
        short letterOne = msg.getUnsignedByte(msg.readerIndex());
        short letterTwo = msg.getUnsignedByte(msg.readerIndex() + 1);
        short letterThree = msg.getUnsignedByte(msg.readerIndex() + 2);
        return letterOne == 71 && letterTwo == 69 && letterThree == 84 || letterOne == 80 && letterTwo == 79 && letterThree == 83 || letterOne == 80 && letterTwo == 85 && letterThree == 84 || letterOne == 72 && letterTwo == 69 && letterThree == 65 || letterOne == 79 && letterTwo == 80 && letterThree == 84 || letterOne == 80 && letterTwo == 65 && letterThree == 84 || letterOne == 68 && letterTwo == 69 && letterThree == 76 || letterOne == 84 && letterTwo == 82 && letterThree == 65 || letterOne == 67 && letterTwo == 79 && letterThree == 78;
    }

    private void enableSsl(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new ChannelHandler[]{new SslHandler(SSLFactory.createServerSSLEngine())});
        ctx.channel().attr(SSL_ENABLED).set((Object)Boolean.TRUE);
        ctx.pipeline().fireChannelRead((Object)msg);
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        if (this.logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler()});
        }
        this.configurePipeline(ctx, pipeline);
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)msg);
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, ChannelPipeline var2);
}

