/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.slf4j.event.Level;

public class JsonSchemaMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "jsonSchemaValidator"};
    private final MockServerLogger mockServerLogger;
    private String matcher;
    private JsonSchemaValidator jsonSchemaValidator;

    JsonSchemaMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        this.jsonSchemaValidator = new JsonSchemaValidator(mockServerLogger, matcher);
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        try {
            String validation = this.jsonSchemaValidator.isValid(matched, false);
            result = validation.isEmpty();
            if (!result) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json schema match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, validation));
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json schema match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, e.getMessage()));
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

