/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.service.apacheclient;

import com.google.common.base.Charsets;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mockserver.model.Book;
import org.mockserver.service.BookService;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BookServiceApacheHttpClient
implements BookService {
    @Resource
    private Environment environment;
    private Integer port;
    private String host;
    private ObjectMapper objectMapper;
    private HttpClient httpClient;

    @PostConstruct
    private void initialise() {
        this.port = (Integer)this.environment.getProperty("bookService.port", Integer.class);
        this.host = this.environment.getProperty("bookService.host", "localhost");
        this.objectMapper = this.createObjectMapper();
        this.httpClient = this.createHttpClient();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_NUMBERS_FOR_ENUMS, false);
        objectMapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationConfig.Feature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(DeserializationConfig.Feature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        return objectMapper;
    }

    private HttpClient createHttpClient() {
        if (Boolean.parseBoolean(System.getProperty("proxySet"))) {
            HttpHost httpHost = new HttpHost(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
            DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(httpHost);
            return HttpClients.custom().setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner).build();
        }
        return HttpClients.custom().build();
    }

    public Book[] getAllBooks() {
        String responseBody = "";
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost(this.host).setPort(this.port.intValue()).setPath("/get_books").build()));
            responseBody = new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to retrieve all books", e);
        }
        try {
            return (Book[])this.objectMapper.readValue(responseBody, Book[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing JSON response [" + responseBody + "]", e);
        }
    }

    public Book getBook(String id) {
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost(this.host).setPort(this.port.intValue()).setPath("/get_book").setParameter("id", id).build()));
            return (Book)this.objectMapper.readValue(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Book.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to retrieve a book with id [" + id + "]", e);
        }
    }
}

