/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.proxy;

import com.google.common.base.Charsets;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.net.Socket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.socket.SSLFactory;
import org.mockserver.streams.IOStreamUtils;
import org.mockserver.verify.VerificationTimes;

public abstract class AbstractClientProxyIntegrationTest {
    protected static String servletContext = "";

    protected HttpClient createHttpClient() throws Exception {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setSslcontext(SSLFactory.getInstance().sslContext()).setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
        if (Boolean.parseBoolean(System.getProperty("defaultProxySet"))) {
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
        } else if (Boolean.parseBoolean(System.getProperty("proxySet"))) {
            HttpHost httpHost = new HttpHost(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
            DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(httpHost);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner).build();
        } else {
            HttpHost httpHost = new HttpHost("localhost", this.getProxyPort());
            DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(httpHost);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner);
        }
        return httpClientBuilder.build();
    }

    public abstract int getProxyPort();

    public abstract int getServerPort();

    public abstract int getServerSecurePort();

    protected String calculatePath(String path) {
        return "/" + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsUsingSocketDirectly() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("GET /test_headers_only HTTP/1.1\r\nHost: localhost:" + this.getServerPort() + "\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "X-Test: test_headers_only");
            output.write(("GET /test_headers_and_body HTTP/1.1\r\nHost: localhost:" + this.getServerPort() + "\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            String response = IOStreamUtils.readInputStreamToString((Socket)socket);
            org.mockserver.test.Assert.assertContains(response, "X-Test: test_headers_and_body");
            org.mockserver.test.Assert.assertContains(response, "an_example_body");
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void shouldForwardRequestsUsingHttpClient() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsToUnknownPath() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("GET /unknown HTTP/1.1\r\nHost: localhost:" + this.getServerPort() + "\r\n" + "Connection: close\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 404 Not Found");
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void shouldVerifyRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_only").build()));
        proxyClient.verify(new HttpRequest[]{HttpRequest.request().withMethod("GET").withPath(this.calculatePath("test_headers_and_body"))});
        proxyClient.verify(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("test_headers_and_body")), VerificationTimes.exactly((int)1));
        proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_.*")), VerificationTimes.atLeast((int)1));
        proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_.*")), VerificationTimes.exactly((int)2));
        proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("other_path")), VerificationTimes.exactly((int)0));
    }

    @Test
    public void shouldVerifyZeroRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        try {
            proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), VerificationTimes.exactly((int)0));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 0 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("test_headers_and_body") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("test_headers_and_body") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNoRequestsExactly() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        try {
            proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("other_path")), VerificationTimes.exactly((int)1));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly once, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("other_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("test_headers_and_body") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNoRequestsTimesNotSpecified() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        try {
            proxyClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("other_path"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("other_path") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("test_headers_and_body") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNotEnoughRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        try {
            proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), VerificationTimes.atLeast((int)3));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least 3 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("test_headers_and_body") + "\"" + System.getProperty("line.separator") + "}> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("test_headers_and_body") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldClearRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_only").build()));
        proxyClient.clear(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("test_headers_and_body")));
        proxyClient.verify(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("test_headers_and_body")), VerificationTimes.exactly((int)0));
        proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_.*")), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldResetRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        ProxyClient proxyClient = new ProxyClient("127.0.0.1", this.getProxyPort()).reset();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_and_body").build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath("/test_headers_only").build()));
        proxyClient.reset();
        proxyClient.verify(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("test_headers_and_body")), VerificationTimes.exactly((int)0));
        proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_.*")), VerificationTimes.atLeast((int)0));
        proxyClient.verify(HttpRequest.request().withPath(this.calculatePath("test_headers_.*")), VerificationTimes.exactly((int)0));
    }
}

