/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MatchableInvocation;

public class VerificationDataImpl
implements VerificationData {
    private final InvocationMatcher wanted;
    private final InvocationContainer invocations;

    public VerificationDataImpl(InvocationContainer invocations, InvocationMatcher wanted) {
        this.invocations = invocations;
        this.wanted = wanted;
        this.assertWantedIsVerifiable();
    }

    @Override
    public List<Invocation> getAllInvocations() {
        return this.invocations.getInvocations();
    }

    @Override
    public MatchableInvocation getTarget() {
        return this.wanted;
    }

    @Override
    public InvocationMatcher getWanted() {
        return this.wanted;
    }

    private void assertWantedIsVerifiable() {
        if (this.wanted == null) {
            return;
        }
        if (ObjectMethodsGuru.isToStringMethod(this.wanted.getMethod())) {
            throw Reporter.cannotVerifyToString();
        }
    }
}

