/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class NumberOfInvocationsChecker {
    private NumberOfInvocationsChecker() {
    }

    public static void checkNumberOfInvocations(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount) {
        List<Invocation> actualInvocations = InvocationsFinder.findInvocations(invocations, wanted);
        int actualCount = actualInvocations.size();
        if (wantedCount > actualCount) {
            Location lastInvocation = InvocationsFinder.getLastLocation(actualInvocations);
            throw Reporter.tooLittleActualInvocations(new Discrepancy(wantedCount, actualCount), wanted, lastInvocation);
        }
        if (wantedCount == 0 && actualCount > 0) {
            Location firstUndesired = actualInvocations.get(wantedCount).getLocation();
            throw Reporter.neverWantedButInvoked(wanted, firstUndesired);
        }
        if (wantedCount < actualCount) {
            Location firstUndesired = actualInvocations.get(wantedCount).getLocation();
            throw Reporter.tooManyActualInvocations(wantedCount, actualCount, wanted, firstUndesired);
        }
        InvocationMarker.markVerified(actualInvocations, wanted);
    }

    public static void checkNumberOfInvocations(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext context) {
        List<Invocation> chunk = InvocationsFinder.findMatchingChunk(invocations, wanted, wantedCount, context);
        int actualCount = chunk.size();
        if (wantedCount > actualCount) {
            Location lastInvocation = InvocationsFinder.getLastLocation(chunk);
            throw Reporter.tooLittleActualInvocationsInOrder(new Discrepancy(wantedCount, actualCount), wanted, lastInvocation);
        }
        if (wantedCount < actualCount) {
            Location firstUndesired = chunk.get(wantedCount).getLocation();
            throw Reporter.tooManyActualInvocationsInOrder(wantedCount, actualCount, wanted, firstUndesired);
        }
        InvocationMarker.markVerifiedInOrder(chunk, wanted, context);
    }

    public static void checkNumberOfInvocationsNonGreedy(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext context) {
        Location lastLocation = null;
        for (int actualCount = 0; actualCount < wantedCount; ++actualCount) {
            Invocation next = InvocationsFinder.findFirstMatchingUnverifiedInvocation(invocations, wanted, context);
            if (next == null) {
                throw Reporter.tooLittleActualInvocationsInOrder(new Discrepancy(wantedCount, actualCount), wanted, lastLocation);
            }
            InvocationMarker.markVerified(next, wanted);
            context.markVerified(next);
            lastLocation = next.getLocation();
        }
    }
}

