/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers.text;

import java.lang.reflect.Array;
import java.util.Iterator;

class ArrayIterator
implements Iterator<Object> {
    private final Object array;
    private int currentIndex = 0;

    public ArrayIterator(Object array) {
        if (array == null) {
            throw new IllegalArgumentException("Expected array instance but got null");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Expected array but got object of type: " + array.getClass() + ", the object: " + array.toString());
        }
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < Array.getLength(this.array);
    }

    @Override
    public Object next() {
        return Array.get(this.array, this.currentIndex++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove items from an array");
    }
}

