/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.stubbing.BaseStubbing;
import org.mockito.internal.stubbing.ConsecutiveStubbing;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.invocation.Invocation;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

public class OngoingStubbingImpl<T>
extends BaseStubbing<T> {
    private final InvocationContainerImpl invocationContainerImpl;

    public OngoingStubbingImpl(InvocationContainerImpl invocationContainerImpl) {
        this.invocationContainerImpl = invocationContainerImpl;
    }

    @Override
    public OngoingStubbing<T> thenAnswer(Answer<?> answer) {
        if (!this.invocationContainerImpl.hasInvocationForPotentialStubbing()) {
            throw Reporter.incorrectUseOfApi();
        }
        this.invocationContainerImpl.addAnswer(answer);
        return new ConsecutiveStubbing(this.invocationContainerImpl);
    }

    @Override
    public OngoingStubbing<T> then(Answer<?> answer) {
        return this.thenAnswer(answer);
    }

    public List<Invocation> getRegisteredInvocations() {
        return this.invocationContainerImpl.getInvocations();
    }

    @Override
    public <M> M getMock() {
        return (M)this.invocationContainerImpl.invokedMock();
    }
}

