/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.io.Serializable;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.objenesis.ObjenesisHelper;

public class ThrowsExceptionClass
implements Answer<Object>,
Serializable {
    private final Class<? extends Throwable> throwableClass;
    private final ConditionalStackTraceFilter filter = new ConditionalStackTraceFilter();

    public ThrowsExceptionClass(Class<? extends Throwable> throwableClass) {
        this.throwableClass = this.checkNonNullThrowable(throwableClass);
    }

    private Class<? extends Throwable> checkNonNullThrowable(Class<? extends Throwable> throwableClass) {
        if (throwableClass == null || !Throwable.class.isAssignableFrom(throwableClass)) {
            throw Reporter.notAnException();
        }
        return throwableClass;
    }

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Throwable throwable = (Throwable)ObjenesisHelper.newInstance(this.throwableClass);
        throwable.fillInStackTrace();
        this.filter.filter(throwable);
        throw throwable;
    }

    public Class<? extends Throwable> getThrowableClass() {
        return this.throwableClass;
    }
}

