/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mockito.codegen.InjectionBase;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.bytebuddy.ByteBuddyCrossClassLoaderSerializationSupport;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.ModuleHandler;
import org.mockito.internal.creation.bytebuddy.SubclassInjectionLoader;
import org.mockito.internal.creation.bytebuddy.SubclassLoader;
import org.mockito.internal.util.StringUtil;
import org.mockito.mock.SerializableMode;

class SubclassBytecodeGenerator
implements BytecodeGenerator {
    private static final String CODEGEN_PACKAGE = "org.mockito.codegen.";
    private final SubclassLoader loader;
    private final ModuleHandler handler;
    private final ByteBuddy byteBuddy;
    private final Random random;
    private final Implementation readReplace;
    private final ElementMatcher<? super MethodDescription> matcher;
    private final Implementation dispatcher = MethodDelegation.to(MockMethodInterceptor.DispatcherDefaultingToRealMethod.class);
    private final Implementation hashCode = MethodDelegation.to(MockMethodInterceptor.ForHashCode.class);
    private final Implementation equals = MethodDelegation.to(MockMethodInterceptor.ForEquals.class);
    private final Implementation writeReplace = MethodDelegation.to(MockMethodInterceptor.ForWriteReplace.class);

    public SubclassBytecodeGenerator() {
        this(new SubclassInjectionLoader());
    }

    public SubclassBytecodeGenerator(SubclassLoader loader) {
        this(loader, null, (ElementMatcher<? super MethodDescription>)ElementMatchers.any());
    }

    public SubclassBytecodeGenerator(Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this(new SubclassInjectionLoader(), readReplace, matcher);
    }

    protected SubclassBytecodeGenerator(SubclassLoader loader, Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this.loader = loader;
        this.readReplace = readReplace;
        this.matcher = matcher;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        this.random = new Random();
        this.handler = ModuleHandler.make(this.byteBuddy, loader, this.random);
    }

    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        ClassLoader classLoader = new MultipleParentClassLoader.Builder().appendMostSpecific(this.getAllTypes(features.mockedType)).appendMostSpecific(features.interfaces).appendMostSpecific(new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).appendMostSpecific(new Class[]{MockAccess.class}).build();
        boolean localMock = classLoader == features.mockedType.getClassLoader() && features.serializableMode != SerializableMode.ACROSS_CLASSLOADERS && !this.isComingFromJDK(features.mockedType) && (this.loader.isDisrespectingOpenness() || this.handler.isOpened(features.mockedType, MockAccess.class));
        String typeName = localMock || this.loader instanceof MultipleParentClassLoader && !this.isComingFromJDK(features.mockedType) ? features.mockedType.getName() : InjectionBase.class.getPackage().getName() + "." + features.mockedType.getSimpleName();
        String name = String.format("%s$%s$%d", typeName, "MockitoMock", Math.abs(this.random.nextInt()));
        if (localMock) {
            this.handler.adjustModuleGraph(features.mockedType, MockAccess.class, false, true);
            for (Class<?> iFace : features.interfaces) {
                this.handler.adjustModuleGraph(iFace, features.mockedType, true, false);
                this.handler.adjustModuleGraph(features.mockedType, iFace, false, true);
            }
        } else {
            boolean exported = this.handler.isExported(features.mockedType);
            Iterator<Class<?>> it = features.interfaces.iterator();
            while (exported && it.hasNext()) {
                exported = this.handler.isExported(it.next());
            }
            if (exported) {
                SubclassBytecodeGenerator.assertVisibility(features.mockedType);
                for (Class<?> iFace : features.interfaces) {
                    SubclassBytecodeGenerator.assertVisibility(iFace);
                }
            } else {
                Class<?> hook = this.handler.injectionBase(classLoader, typeName);
                SubclassBytecodeGenerator.assertVisibility(features.mockedType);
                this.handler.adjustModuleGraph(features.mockedType, hook, true, false);
                for (Class<?> iFace : features.interfaces) {
                    SubclassBytecodeGenerator.assertVisibility(iFace);
                    this.handler.adjustModuleGraph(iFace, hook, true, false);
                }
            }
        }
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = this.byteBuddy.subclass(features.mockedType).name(name).ignoreAlso(SubclassBytecodeGenerator.isGroovyMethod()).annotateType(features.stripAnnotations ? new Annotation[]{} : features.mockedType.getAnnotations()).implement(new ArrayList(features.interfaces)).method(this.matcher).intercept(this.dispatcher).transform(Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN})).attribute((MethodAttributeAppender.Factory)(features.stripAnnotations ? MethodAttributeAppender.NoOp.INSTANCE : MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER)).method((ElementMatcher)ElementMatchers.isHashCode()).intercept(this.hashCode).method((ElementMatcher)ElementMatchers.isEquals()).intercept(this.equals).serialVersionUid(42L).defineField("mockitoInterceptor", MockMethodInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{MockAccess.class}).intercept((Implementation)FieldAccessor.ofBeanProperty());
        if (features.serializableMode == SerializableMode.ACROSS_CLASSLOADERS) {
            builder = builder.implement(new Type[]{ByteBuddyCrossClassLoaderSerializationSupport.CrossClassLoaderSerializableMock.class}).intercept(this.writeReplace);
        }
        if (this.readReplace != null) {
            builder = builder.defineMethod("readObject", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).withParameters(new Type[]{ObjectInputStream.class}).throwing(new Type[]{ClassNotFoundException.class, IOException.class}).intercept(this.readReplace);
        }
        if (name.startsWith(CODEGEN_PACKAGE) || classLoader instanceof MultipleParentClassLoader) {
            builder = builder.ignoreAlso((ElementMatcher)ElementMatchers.isPackagePrivate().or((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.isPackagePrivate())).or((ElementMatcher)ElementMatchers.hasParameters((ElementMatcher)ElementMatchers.whereAny((ElementMatcher)ElementMatchers.hasType((ElementMatcher)ElementMatchers.isPackagePrivate())))));
        }
        return builder.make().load(classLoader, this.loader.resolveStrategy(features.mockedType, classLoader, localMock)).getLoaded();
    }

    @Override
    public void mockClassStatic(Class<?> type) {
        throw new MockitoException("The subclass byte code generator cannot create static mocks");
    }

    @Override
    public void mockClassConstruction(Class<?> type) {
        throw new MockitoException("The subclass byte code generator cannot create construction mocks");
    }

    private <T> Collection<Class<? super T>> getAllTypes(Class<T> type) {
        LinkedList<Class<T>> supertypes = new LinkedList<Class<T>>();
        supertypes.add(type);
        for (Class<T> superType = type; superType != null; superType = superType.getSuperclass()) {
            supertypes.add(superType);
        }
        return supertypes;
    }

    private static ElementMatcher<MethodDescription> isGroovyMethod() {
        return ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.named((String)"groovy.lang.GroovyObjectSupport"));
    }

    private boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private static void assertVisibility(Class<?> type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            throw new MockitoException(StringUtil.join("Cannot create mock for " + type, "", "The type is not public and its mock class is loaded by a different class loader.", "This can have multiple reasons:", " - You are mocking a class with additional interfaces of another class loader", " - Mockito is loaded by a different class loader than the mocked type (e.g. with OSGi)", " - The thread's context class loader is different than the mock's class loader"));
        }
    }
}

