/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.plugins.MemberAccessor;

public class ReflectionMemberAccessor
implements MemberAccessor {
    @Override
    public Object newInstance(Constructor<?> constructor, Object ... arguments) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        return this.newInstance(constructor, MemberAccessor.ConstructionDispatcher::newInstance, arguments);
    }

    @Override
    public Object newInstance(Constructor<?> constructor, MemberAccessor.OnConstruction onConstruction, Object ... arguments) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        ReflectionMemberAccessor.silentSetAccessible(constructor, true);
        try {
            Object object = onConstruction.invoke(() -> constructor.newInstance(arguments));
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to invoke " + constructor + " with " + Arrays.toString(arguments), e);
        }
        finally {
            ReflectionMemberAccessor.silentSetAccessible(constructor, false);
        }
    }

    @Override
    public Object invoke(Method method, Object target, Object ... arguments) throws InvocationTargetException, IllegalAccessException {
        ReflectionMemberAccessor.silentSetAccessible(method, true);
        try {
            Object object = method.invoke(target, arguments);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke " + method + " on " + target, e);
        }
        finally {
            ReflectionMemberAccessor.silentSetAccessible(method, false);
        }
    }

    @Override
    public Object get(Field field, Object target) throws IllegalAccessException {
        ReflectionMemberAccessor.silentSetAccessible(field, true);
        try {
            Object object = field.get(target);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not read " + field + " from " + target);
        }
        finally {
            ReflectionMemberAccessor.silentSetAccessible(field, false);
        }
    }

    @Override
    public void set(Field field, Object target, Object value) throws IllegalAccessException {
        ReflectionMemberAccessor.silentSetAccessible(field, true);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not write " + field + " to " + target, e);
        }
        finally {
            ReflectionMemberAccessor.silentSetAccessible(field, false);
        }
    }

    private static void silentSetAccessible(AccessibleObject object, boolean value) {
        try {
            object.setAccessible(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

