/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.stubbing.StrictnessSelector;
import org.mockito.internal.stubbing.UnusedStubbingReporting;
import org.mockito.invocation.Invocation;
import org.mockito.listeners.StubbingLookupEvent;
import org.mockito.listeners.StubbingLookupListener;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Stubbing;

class DefaultStubbingLookupListener
implements StubbingLookupListener,
Serializable {
    private static final long serialVersionUID = -6789800638070123629L;
    private Strictness currentStrictness;
    private boolean mismatchesReported;

    DefaultStubbingLookupListener(Strictness strictness) {
        this.currentStrictness = strictness;
    }

    @Override
    public void onStubbingLookup(StubbingLookupEvent event) {
        Strictness actualStrictness = StrictnessSelector.determineStrictness(event.getStubbingFound(), event.getMockSettings(), this.currentStrictness);
        if (actualStrictness != Strictness.STRICT_STUBS) {
            return;
        }
        if (event.getStubbingFound() == null) {
            List<Invocation> argMismatchStubbings = DefaultStubbingLookupListener.potentialArgMismatches(event.getInvocation(), event.getAllStubbings());
            if (!argMismatchStubbings.isEmpty()) {
                this.mismatchesReported = true;
                Reporter.potentialStubbingProblem(event.getInvocation(), argMismatchStubbings);
            }
        } else {
            event.getInvocation().markVerified();
        }
    }

    private static List<Invocation> potentialArgMismatches(Invocation invocation, Collection<Stubbing> stubbings) {
        LinkedList<Invocation> matchingStubbings = new LinkedList<Invocation>();
        for (Stubbing s : stubbings) {
            if (!UnusedStubbingReporting.shouldBeReported(s) || !Objects.equals(s.getInvocation().getMethod().getName(), invocation.getMethod().getName()) || Objects.equals(s.getInvocation().getLocation().getSourceFile(), invocation.getLocation().getSourceFile())) continue;
            matchingStubbings.add(s.getInvocation());
        }
        return matchingStubbings;
    }

    void setCurrentStrictness(Strictness currentStrictness) {
        this.currentStrictness = currentStrictness;
    }

    boolean isMismatchesReported() {
        return this.mismatchesReported;
    }
}

