/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;

public interface Document
extends Serializable {
    public Object get(String var1);

    public Boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    public Integer getInteger(String var1);

    public int getInteger(String var1, int var2);

    public Long getLong(String var1);

    public long getLong(String var1, long var2);

    public Double getDouble(String var1);

    public double getDouble(String var1, double var2);

    public Number getNumber(String var1);

    public Number getNumber(String var1, Number var2);

    public String getString(String var1);

    public String getString(String var1, String var2);

    public List<?> getArray(String var1);

    public Document getDocument(String var1);

    public boolean isNull(String var1);

    public boolean isNullOrMissing(String var1);

    public MaxKey getMaxKey(String var1);

    public MinKey getMinKey(String var1);

    public Code getCode(String var1);

    public CodeWithScope getCodeWithScope(String var1);

    public ObjectId getObjectId(String var1);

    public Binary getBinary(String var1);

    public Symbol getSymbol(String var1);

    public Pattern getPattern(String var1);

    public UUID getUuid(String var1);

    public UUID getUuid(String var1, UUID var2);

    public int getType(String var1);

    public Map<String, ? extends Object> toMap();

    public Iterable<Field> fields();

    public boolean containsField(String var1);

    public boolean containsAll(Document var1);

    public Set<String> keySet();

    public int size();

    public boolean isEmpty();

    public Document clone();

    public Document with(Map<String, Object> var1);

    public Document with(String var1, Object var2);

    public Document with(ValueTransformer var1);

    public Document withVariablesReplaced(Properties var1);

    public Document withVariablesReplacedWithSystemProperties();

    public static interface Field
    extends Comparable<Field> {
        public String getName();

        public Object getValue();

        public String getValueAsString();

        public Integer getValueAsInt();

        public boolean getValueAsBoolean();

        public Binary getValueAsBinary();

        public Number getValueAsNumber();

        public Pattern getValueAsPattern();

        public Double getValueAsDouble();

        public UUID getValueAsUuid();

        public Document getValueAsDocument();
    }

    public static interface ValueTransformer {
        public Object transform(String var1, Object var2);
    }
}

