/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.BsonDBPointerSerializer;

@Serializable(with=BsonDBPointerSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/mongodb/kbson/BsonDBPointer;", "Lorg/mongodb/kbson/BsonValue;", "namespace", "", "id", "Lorg/mongodb/kbson/BsonObjectId;", "(Ljava/lang/String;Lorg/mongodb/kbson/BsonObjectId;)V", "bsonType", "Lorg/mongodb/kbson/BsonType;", "getBsonType", "()Lorg/mongodb/kbson/BsonType;", "getId", "()Lorg/mongodb/kbson/BsonObjectId;", "getNamespace", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "kbson_debug"})
public final class BsonDBPointer
extends BsonValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String namespace;
    @NotNull
    private final BsonObjectId id;

    public BsonDBPointer(@NotNull String namespace, @NotNull BsonObjectId id) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(null);
        this.namespace = namespace;
        this.id = id;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final BsonObjectId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public BsonType getBsonType() {
        return BsonType.DB_POINTER;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        BsonDBPointer cfr_ignored_0 = (BsonDBPointer)other;
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)((BsonDBPointer)other).namespace)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)((BsonDBPointer)other).id);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "BsonDBPointer(namespace='" + this.namespace + "', id=" + this.id + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/mongodb/kbson/BsonDBPointer$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/mongodb/kbson/BsonDBPointer;", "kbson_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<BsonDBPointer> serializer() {
            return BsonDBPointerSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

