/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004J\f\u0010\u0010\u001a\u00020\b*\u00020\bH\u0002J\f\u0010\u0011\u001a\u00020\b*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/mongodb/kbson/internal/Base64Utils;", "", "()V", "BASE64_ALPHABET", "", "BASE64_INVERSE_ALPHABET", "", "BASE64_MASK", "", "BASE64_PAD", "", "toBase64String", "byteArray", "", "toByteArray", "base64", "fromBase64", "toBase64", "", "kbson_debug"})
public final class Base64Utils {
    @NotNull
    public static final Base64Utils INSTANCE = new Base64Utils();
    @NotNull
    private static final String BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte BASE64_MASK = 63;
    private static final char BASE64_PAD = '=';
    @NotNull
    private static final int[] BASE64_INVERSE_ALPHABET;

    private Base64Utils() {
    }

    @NotNull
    public final String toBase64String(@NotNull byte[] byteArray) {
        int n;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        List output = new ArrayList();
        int padding = 0;
        for (int position = 0; position < byteArray.length; position += 3) {
            int b = 0;
            b = (byteArray[position] & 0xFF) << 16 & 0xFFFFFF;
            if (position + 1 < byteArray.length) {
                b |= (byteArray[position + 1] & 0xFF) << 8;
            } else {
                n = padding;
                padding = n + 1;
            }
            if (position + 2 < byteArray.length) {
                b |= byteArray[position + 2] & 0xFF;
            } else {
                n = padding;
                padding = n + 1;
            }
            int remaining = 4 - padding;
            int n2 = 0;
            while (n2 < remaining) {
                int n3;
                int it = n3 = n2++;
                boolean bl = false;
                int c = (b & 0xFC0000) >> 18;
                output.add(INSTANCE.toBase64(c));
                b <<= 6;
            }
        }
        int n4 = 0;
        while (n4 < padding) {
            int it = n = n4++;
            boolean bl = false;
            output.add((byte)61);
        }
        return StringsKt.decodeToString((byte[])CollectionsKt.toByteArray((Collection)output));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] toByteArray(@NotNull String base64) {
        Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
        char[] cArray = new char[]{'='};
        byte[] byteArray = StringsKt.encodeToByteArray((String)StringsKt.trimEnd((String)base64, (char[])cArray));
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)ArraysKt.toList((byte[])byteArray), (int)4);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$foldIndexed$iv;
            List data = (List)element$iv;
            boolean bl = false;
            Iterable iterable = data;
            int initial$iv = 0;
            boolean $i$f$foldIndexed = false;
            int index$iv = 0;
            int accumulator$iv = initial$iv;
            for (Object element$iv2 : $this$foldIndexed$iv) {
                void current;
                void result;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                byte by = ((Number)element$iv2).byteValue();
                int n2 = accumulator$iv;
                int index = n;
                boolean bl2 = false;
                accumulator$iv = result | INSTANCE.fromBase64((byte)current) << (3 - index) * 6;
            }
            int chunk = accumulator$iv;
            int count = data.size() - 1;
            int b = chunk;
            while (count > 0) {
                int c = (b & 0xFF0000) >> 16;
                bytes.add((byte)c);
                b <<= 8;
                int n = count;
                count = n + -1;
            }
        }
        return CollectionsKt.toByteArray((Collection)bytes);
    }

    private final byte toBase64(int $this$toBase64) {
        return (byte)BASE64_ALPHABET.charAt($this$toBase64);
    }

    private final byte fromBase64(byte $this$fromBase64) {
        return (byte)((byte)BASE64_INVERSE_ALPHABET[$this$fromBase64 & 0xFF] & 0x3F);
    }

    static {
        int n = 0;
        int[] nArray = new int[256];
        while (n < 256) {
            int n2 = n++;
            nArray[n2] = StringsKt.indexOf$default((CharSequence)BASE64_ALPHABET, (char)((char)n2), (int)0, (boolean)false, (int)6, null);
        }
        BASE64_INVERSE_ALPHABET = nArray;
    }
}

